/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.RemoteGraph;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    public void shouldTraverseV() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]), false);
    }

    @Test
    public void shouldTraverseV_out() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).out(), false);
    }

    @Test
    public void shouldTraverseV_in() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).in(), false);
    }

    @Test
    public void shouldTraverseV_in_in() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).in(), false);
    }

    @Test
    public void shouldTraverseE() {
        this.assertTraversal((Traversal)this.create().E(new Object[0]), false);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_out_addInE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).out().addE("test").from("a"), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_out_addOutE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).out().addE("test").to("a"), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addInE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).in().addE("test").from("a"), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addOutE() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).in().addE("test").to("a"), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addEXINX() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).in().addE("test").from("a"), true);
    }

    @Test
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void shouldNotTraverseV_In_addEXOUTX() {
        this.assertTraversal((Traversal)this.create().V(new Object[0]).as("a", new String[0]).in().addE("test").to("a"), true);
    }

    private GraphTraversalSource create() {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{ReadOnlyStrategy.instance()});
    }

    private void assertTraversal(Traversal t, boolean expectMutatingStep) {
        block6: {
            try {
                if (this.graph instanceof RemoteGraph) {
                    t.hasNext();
                } else {
                    t.asAdmin().applyStrategies();
                }
                if (expectMutatingStep) {
                    Assert.fail((String)"The strategy should have found a mutating step.");
                }
            }
            catch (Exception ise) {
                if (!expectMutatingStep) {
                    Assert.fail((String)"The traversal should not have failed as there is no mutating step.");
                }
                if (ise instanceof VerificationException) break block6;
                MatcherAssert.assertThat((Object)ise.getMessage(), (Matcher)StringContains.containsString((String)"The provided traversal has a mutating step and thus is not read only"));
            }
        }
    }
}

