/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class SideEffectTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Object> get_g_V_valuesXnameX_sideEffectXidentityX();

    public abstract Traversal<Vertex, Object> get_g_V_valuesXnameX_sideEffectXidentity_substringX1XX();

    public abstract Traversal<Vertex, String> get_g_withSideEffectXx_setX_V_both_both_sideEffectX_localX_aggregateXxX_byXnameXX_capXxX_unfold();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_valuesXnameX_sideEffectXidentityX() {
        Traversal<Vertex, Object> traversal = this.get_g_V_valuesXnameX_sideEffectXidentityX();
        this.printTraversalForm(traversal);
        SideEffectTest.checkResults(Arrays.asList("josh", "peter", "ripple", "marko", "vadas", "lop"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_V_valuesXnameX_sideEffectXidentity_substringX1XX() {
        Traversal<Vertex, Object> traversal = this.get_g_V_valuesXnameX_sideEffectXidentity_substringX1XX();
        this.printTraversalForm(traversal);
        SideEffectTest.checkResults(Arrays.asList("josh", "peter", "ripple", "marko", "vadas", "lop"), traversal);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void g_withSideEffectXx_setX_V_both_both_sideEffectXstoreXxX_byXnameXX_capXxX_unfold() {
        Traversal<Vertex, String> traversal = this.get_g_withSideEffectXx_setX_V_both_both_sideEffectX_localX_aggregateXxX_byXnameXX_capXxX_unfold();
        this.printTraversalForm(traversal);
        SideEffectTest.checkResults(Arrays.asList("josh", "peter", "ripple", "marko", "vadas", "lop"), traversal);
        SideEffectTest.checkSideEffects(traversal.asAdmin().getSideEffects(), "x", HashSet.class);
    }

    public static class Traversals
    extends SideEffectTest {
        @Override
        public Traversal<Vertex, Object> get_g_V_valuesXnameX_sideEffectXidentityX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).sideEffect((Traversal)__.identity());
        }

        @Override
        public Traversal<Vertex, Object> get_g_V_valuesXnameX_sideEffectXidentity_substringX1XX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).sideEffect((Traversal)__.identity().substring(1));
        }

        @Override
        public Traversal<Vertex, String> get_g_withSideEffectXx_setX_V_both_both_sideEffectX_localX_aggregateXxX_byXnameXX_capXxX_unfold() {
            return this.g.withSideEffect("x", new HashSet()).V(new Object[0]).both().both().sideEffect((Traversal)__.local((Traversal)__.aggregate((String)"x").by("name"))).cap("x", new String[0]).unfold();
        }
    }
}

