/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class MeanTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Double> get_g_V_age_mean();

    public abstract Traversal<Vertex, Double> get_g_V_age_fold_meanXlocalX();

    public abstract Traversal<Vertex, Number> get_g_V_foo_mean();

    public abstract Traversal<Vertex, Number> get_g_V_foo_fold_meanXlocalX();

    public abstract Traversal<Vertex, Map<String, Number>> get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX();

    public abstract Traversal<Vertex, Double> get_g_V_aggregateXaX_byXageX_meanXlocalX();

    public abstract Traversal<Vertex, Double> get_g_V_aggregateXaX_byXageX_capXaX_unfold_mean();

    public abstract Traversal<Vertex, Double> get_g_V_aggregateXaX_byXfooX_meanXlocalX();

    public abstract Traversal<Vertex, Double> get_g_V_aggregateXaX_byXfooX_capXaX_unfold_mean();

    public abstract Traversal<Integer, Double> get_g_injectXnull_10_20_nullX_mean();

    public abstract Traversal<List<Integer>, Double> get_g_injectXlistXnull_10_20_nullXX_meanXlocalX();

    public abstract Traversal<Vertex, Double> get_g_VX1X_valuesXageX_meanXlocalX(Object var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_age_mean() {
        for (Traversal traversal : Arrays.asList(this.get_g_V_age_mean(), this.get_g_V_age_fold_meanXlocalX())) {
            this.printTraversalForm(traversal);
            Double mean = (Double)traversal.next();
            Assert.assertEquals((double)30.75, (double)mean, (double)0.05);
            Assert.assertFalse((boolean)traversal.hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_foo_mean() {
        for (Traversal traversal : Arrays.asList(this.get_g_V_foo_mean(), this.get_g_V_foo_fold_meanXlocalX())) {
            this.printTraversalForm(traversal);
            Assert.assertFalse((boolean)traversal.hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_aggregateXaX_byXfooX_meanXlocalX() {
        Traversal<Vertex, Double> traversal = this.get_g_V_aggregateXaX_byXfooX_meanXlocalX();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_aggregateXaX_byXfooX_capXaX_unfold_mean() {
        Traversal<Vertex, Double> traversal = this.get_g_V_aggregateXaX_byXfooX_capXaX_unfold_mean();
        this.printTraversalForm(traversal);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX() {
        Traversal<Vertex, Map<String, Number>> traversal = this.get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX();
        this.printTraversalForm(traversal);
        Assert.assertTrue((boolean)traversal.hasNext());
        Map map = (Map)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)1.0, map.get("ripple"));
        Assert.assertEquals((Object)0.3333333333333333, map.get("lop"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_aggregateXaX_byXageX_meanXlocalX() {
        for (Traversal traversal : Arrays.asList(this.get_g_V_aggregateXaX_byXageX_capXaX_unfold_mean(), this.get_g_V_aggregateXaX_byXageX_meanXlocalX())) {
            this.printTraversalForm(traversal);
            Double mean = (Double)traversal.next();
            Assert.assertEquals((double)30.75, (double)mean, (double)0.05);
            Assert.assertFalse((boolean)traversal.hasNext());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_injectXnull_10_20_nullX_mean() {
        Traversal<Integer, Double> traversal = this.get_g_injectXnull_10_20_nullX_mean();
        this.printTraversalForm(traversal);
        Double mean = (Double)traversal.next();
        Assert.assertEquals((double)15.0, (double)mean, (double)0.05);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_injectXlistXnull_10_20_nullXX_meanXlocalX() {
        Traversal<List<Integer>, Double> traversal = this.get_g_injectXlistXnull_10_20_nullXX_meanXlocalX();
        this.printTraversalForm(traversal);
        Double mean = (Double)traversal.next();
        Assert.assertEquals((double)15.0, (double)mean, (double)0.05);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_VX1X_valuesXageX_meanXlocalX() {
        Traversal<Vertex, Double> traversal = this.get_g_VX1X_valuesXageX_meanXlocalX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        MeanTest.checkResults(Arrays.asList(29.0), traversal);
    }

    public static class Traversals
    extends MeanTest {
        @Override
        public Traversal<Vertex, Double> get_g_V_age_mean() {
            return this.g.V(new Object[0]).values(new String[]{"age"}).mean();
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_aggregateXaX_byXfooX_meanXlocalX() {
            return this.g.V(new Object[0]).aggregate("a").by("foo").cap("a", new String[0]).mean(Scope.local);
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_aggregateXaX_byXfooX_capXaX_unfold_mean() {
            return this.g.V(new Object[0]).aggregate("a").by("foo").cap("a", new String[0]).unfold().mean();
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_age_fold_meanXlocalX() {
            return this.g.V(new Object[0]).values(new String[]{"age"}).fold().mean(Scope.local);
        }

        @Override
        public Traversal<Vertex, Number> get_g_V_foo_mean() {
            return this.g.V(new Object[0]).values(new String[]{"foo"}).mean();
        }

        @Override
        public Traversal<Vertex, Number> get_g_V_foo_fold_meanXlocalX() {
            return this.g.V(new Object[0]).values(new String[]{"foo"}).fold().mean(Scope.local);
        }

        @Override
        public Traversal<Vertex, Map<String, Number>> get_g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX() {
            return this.g.V(new Object[0]).hasLabel("software", new String[0]).group().by("name").by((Traversal)__.bothE().values(new String[]{"weight"}).mean());
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_aggregateXaX_byXageX_meanXlocalX() {
            return this.g.V(new Object[0]).aggregate("a").by("age").cap("a", new String[0]).mean(Scope.local);
        }

        @Override
        public Traversal<Vertex, Double> get_g_V_aggregateXaX_byXageX_capXaX_unfold_mean() {
            return this.g.V(new Object[0]).aggregate("a").by("age").cap("a", new String[0]).unfold().mean();
        }

        @Override
        public Traversal<Integer, Double> get_g_injectXnull_10_20_nullX_mean() {
            return this.g.inject((Object[])new Integer[]{null, 10, 20, null}).mean();
        }

        @Override
        public Traversal<List<Integer>, Double> get_g_injectXlistXnull_10_20_nullXX_meanXlocalX() {
            return this.g.inject((Object[])new List[]{Arrays.asList(null, 10, 20, null)}).mean(Scope.local);
        }

        @Override
        public Traversal<Vertex, Double> get_g_VX1X_valuesXageX_meanXlocalX(Object vid1) {
            return this.g.V(new Object[]{vid1}).values(new String[]{"age"}).mean(Scope.local);
        }
    }
}

