/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.search.path;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathTestHelper;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShortestPathVertexProgramTest
extends AbstractGremlinProcessTest {
    private ShortestPathTestHelper helper;
    public static String[][] ALL_SHORTEST_PATHS = new String[][]{{"marko"}, {"marko", "vadas"}, {"marko", "lop"}, {"marko", "lop", "peter"}, {"marko", "josh"}, {"marko", "josh", "ripple"}, {"vadas"}, {"vadas", "marko"}, {"vadas", "marko", "lop"}, {"vadas", "marko", "lop", "peter"}, {"vadas", "marko", "josh", "ripple"}, {"vadas", "marko", "josh"}, {"lop"}, {"lop", "marko"}, {"lop", "marko", "vadas"}, {"lop", "josh"}, {"lop", "josh", "ripple"}, {"lop", "peter"}, {"josh"}, {"josh", "marko"}, {"josh", "marko", "vadas"}, {"josh", "lop"}, {"josh", "lop", "peter"}, {"josh", "ripple"}, {"ripple"}, {"ripple", "josh"}, {"ripple", "josh", "marko"}, {"ripple", "josh", "marko", "vadas"}, {"ripple", "josh", "lop"}, {"ripple", "josh", "lop", "peter"}, {"peter"}, {"peter", "lop"}, {"peter", "lop", "marko"}, {"peter", "lop", "marko", "vadas"}, {"peter", "lop", "josh"}, {"peter", "lop", "josh", "ripple"}};

    @Before
    public void initializeHelper() throws Exception {
        this.helper = new ShortestPathTestHelper(this, this.g);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindAllShortestPathsWithDefaultParameters() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).map(this.helper::makePath).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindAllShortestPathsWithEdgesIncluded() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().includeEdges(true).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).map(p -> this.helper.makePath(true, (String)p)).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindOutDirectedShortestPaths() throws Exception {
        List<ShortestPathVertexProgram> programs = Arrays.asList((ShortestPathVertexProgram)ShortestPathVertexProgram.build().edgeTraversal((Traversal)__.outE()).create(this.graph), (ShortestPathVertexProgram)ShortestPathVertexProgram.build().edgeDirection(Direction.OUT).create(this.graph));
        for (ShortestPathVertexProgram program : programs) {
            ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program((VertexProgram)program).submit().get();
            Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
            List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
            List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && !p[((String[])p).length - 1].equals("peter") || p[0].equals("vadas") && ((String[])p).length == 1 || p[0].equals("lop") && ((String[])p).length == 1 || p[0].equals("josh") && Arrays.asList("lop", "josh", "ripple").contains(p[((String[])p).length - 1]) || p[0].equals("ripple") && ((String[])p).length == 1 || p[0].equals("peter") && Arrays.asList("lop", "peter").contains(p[((String[])p).length - 1])).map(this.helper::makePath).collect(Collectors.toList());
            this.helper.checkResults(expected, shortestPaths);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindInDirectedShortestPaths() throws Exception {
        List<ShortestPathVertexProgram> programs = Arrays.asList((ShortestPathVertexProgram)ShortestPathVertexProgram.build().edgeTraversal((Traversal)__.inE()).create(this.graph), (ShortestPathVertexProgram)ShortestPathVertexProgram.build().edgeDirection(Direction.IN).create(this.graph));
        for (ShortestPathVertexProgram program : programs) {
            ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program((VertexProgram)program).submit().get();
            Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
            List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
            List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && ((String[])p).length == 1 || p[0].equals("vadas") && Arrays.asList("marko", "vadas").contains(p[((String[])p).length - 1]) || p[0].equals("lop") && Arrays.asList("marko", "lop", "josh", "peter").contains(p[((String[])p).length - 1]) || p[0].equals("josh") && Arrays.asList("marko", "josh").contains(p[((String[])p).length - 1]) || p[0].equals("ripple") && Arrays.asList("marko", "josh", "ripple").contains(p[((String[])p).length - 1]) || p[0].equals("peter") && ((String[])p).length == 1).map(this.helper::makePath).collect(Collectors.toList());
            this.helper.checkResults(expected, shortestPaths);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindDirectedShortestPathsWithEdgesIncluded() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().edgeTraversal((Traversal)__.outE()).includeEdges(true).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && !p[((String[])p).length - 1].equals("peter") || p[0].equals("vadas") && ((String[])p).length == 1 || p[0].equals("lop") && ((String[])p).length == 1 || p[0].equals("josh") && Arrays.asList("lop", "josh", "ripple").contains(p[((String[])p).length - 1]) || p[0].equals("ripple") && ((String[])p).length == 1 || p[0].equals("peter") && Arrays.asList("lop", "peter").contains(p[((String[])p).length - 1])).map(p -> this.helper.makePath(true, (String)p)).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindShortestPathsWithStartVertexFilter() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().source((Traversal)__.has((String)"name", (Object)"marko")).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko")).map(this.helper::makePath).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindShortestPathsWithEndVertexFilter() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().target((Traversal)__.has((String)"name", (Object)"marko")).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[((String[])p).length - 1].equals("marko")).map(this.helper::makePath).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldFindShortestPathsWithStartEndVertexFilter() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().source((Traversal)__.has((String)"name", (Object)"marko")).target((Traversal)__.hasLabel((String)"software", (String[])new String[0])).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && Arrays.asList("lop", "ripple").contains(p[((String[])p).length - 1])).map(this.helper::makePath).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldUseCustomDistanceProperty() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().source((Traversal)__.has((String)"name", (Object)"marko")).target((Traversal)__.has((String)"name", (Object)"josh")).distanceProperty("weight").create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        Assert.assertEquals((long)1L, (long)shortestPaths.size());
        Assert.assertEquals((Object)this.helper.makePath("marko", "lop", "josh"), shortestPaths.get(0));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldFindEqualLengthPaths() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().edgeTraversal((Traversal)__.bothE((String[])new String[]{"uses"})).source((Traversal)__.has((String)"name", (Object)"daniel")).target((Traversal)__.has((String)"name", (Object)"stephen")).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.asList(this.helper.makePath("daniel", "gremlin", "stephen"), this.helper.makePath("daniel", "tinkergraph", "stephen"));
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldFindEqualLengthPathsUsingDistanceProperty() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().edgeTraversal((Traversal)__.outE((String[])new String[]{"followedBy"})).source((Traversal)__.has((String)"song", (String)"name", (Object)"MIGHT AS WELL")).target((Traversal)__.has((String)"song", (String)"name", (Object)"MAYBE YOU KNOW HOW I FEEL")).distanceProperty("weight").create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.asList(this.helper.makePath("MIGHT AS WELL", "DRUMS", "MAYBE YOU KNOW HOW I FEEL"), this.helper.makePath("MIGHT AS WELL", "SHIP OF FOOLS", "MAYBE YOU KNOW HOW I FEEL"));
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldRespectMaxDistance() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().source((Traversal)__.has((String)"name", (Object)"marko")).maxDistance((Number)1).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("marko") && ((String[])p).length <= 2).map(this.helper::makePath).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldRespectMaxCustomDistance() throws Exception {
        ComputerResult result = (ComputerResult)this.graph.compute(this.graphProvider.getGraphComputer(this.graph).getClass()).program(ShortestPathVertexProgram.build().source((Traversal)__.has((String)"name", (Object)"vadas")).distanceProperty("weight").maxDistance((Number)1.3).create(this.graph)).submit().get();
        Assert.assertTrue((boolean)result.memory().exists("gremlin.shortestPathVertexProgram.shortestPaths"));
        List shortestPaths = (List)result.memory().get("gremlin.shortestPathVertexProgram.shortestPaths");
        List<Path> expected = Stream.concat(Arrays.stream(ALL_SHORTEST_PATHS).filter(p -> p[0].equals("vadas") && Arrays.asList("vadas", "marko", "lop", "peter").contains(p[((String[])p).length - 1])).map(this.helper::makePath), Stream.of(this.helper.makePath("vadas", "marko", "lop", "josh"))).collect(Collectors.toList());
        this.helper.checkResults(expected, shortestPaths);
    }
}

