/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.List;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SeedStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public class SeedStrategyProcessTest
extends AbstractGremlinProcessTest {
    private static final SeedStrategy seedStrategy = SeedStrategy.build().seed(1234L).create();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSeedCoin() {
        GraphTraversalSource gSeeded = this.create();
        List names = gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).coin(0.31).order().toList();
        this.repeatAssert(() -> {
            Assert.assertEquals((Object)names, (Object)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).coin(0.31).order().toList());
            return null;
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSeedGlobalOrderShuffle() {
        GraphTraversalSource gSeeded = this.create();
        List names = gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).order().by(Order.shuffle).toList();
        this.repeatAssert(() -> {
            Assert.assertEquals((Object)names, (Object)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).order().by(Order.shuffle).toList());
            return null;
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSeedLocalOrderShuffle() {
        GraphTraversalSource gSeeded = this.create();
        List names = (List)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).fold().order(Scope.local).by(Order.shuffle).next();
        this.repeatAssert(() -> {
            Assert.assertEquals((Object)names, (Object)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).fold().order(Scope.local).by(Order.shuffle).next());
            return null;
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldSeedGlobalSample() {
        GraphTraversalSource gSeeded = this.create();
        List names = gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).sample(20).toList();
        this.repeatAssert(() -> {
            Assert.assertEquals((Object)names, (Object)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).sample(20).toList());
            return null;
        });
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldSeedLocalSample() {
        GraphTraversalSource gSeeded = this.create();
        List names = (List)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).fold().sample(Scope.local, 20).next();
        this.repeatAssert(() -> {
            Assert.assertEquals((Object)names, (Object)gSeeded.V(new Object[0]).order().by("name").values(new String[]{"name"}).fold().sample(Scope.local, 20).next());
            return null;
        });
    }

    private void repeatAssert(Supplier<Void> assertion) {
        for (int ix = 0; ix < 128; ++ix) {
            assertion.get();
        }
    }

    private GraphTraversalSource create() {
        return this.g.withStrategies(new TraversalStrategy[]{seedStrategy});
    }
}

