/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkdumping;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.bulkdumping.BulkDumperVertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class BulkDumperVertexProgramTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldDumpWholeGraph() throws Exception {
        if (this.graphProvider.getGraphComputer(this.graph).features().supportsResultGraphPersistCombination(GraphComputer.ResultGraph.NEW, GraphComputer.Persist.EDGES)) {
            ComputerResult result = (ComputerResult)this.graphProvider.getGraphComputer(this.graph).program((VertexProgram)BulkDumperVertexProgram.build().create(this.graph)).submit().get();
            result.graph().traversal().V(new Object[0]).forEachRemaining(v -> {
                Assert.assertEquals((long)2L, (long)v.keys().size());
                Assert.assertTrue((boolean)v.keys().contains("name"));
                Assert.assertTrue((v.keys().contains("age") || v.keys().contains("lang") ? 1 : 0) != 0);
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"name"})));
                Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.values(new String[]{"age", "lang"})));
                String name = (String)v.value("name");
                if (name.equals("marko")) {
                    Assert.assertEquals((Object)"person", (Object)v.label());
                    Assert.assertEquals((Object)29, (Object)v.value("age"));
                    Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[]{"knows"})));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[]{"created"})));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                } else if (name.equals("vadas")) {
                    Assert.assertEquals((Object)"person", (Object)v.label());
                    Assert.assertEquals((Object)27, (Object)v.value("age"));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[]{"knows"})));
                } else if (name.equals("lop")) {
                    Assert.assertEquals((Object)"software", (Object)v.label());
                    Assert.assertEquals((Object)"java", (Object)v.value("lang"));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)3L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[]{"created"})));
                } else if (name.equals("josh")) {
                    Assert.assertEquals((Object)"person", (Object)v.label());
                    Assert.assertEquals((Object)32, (Object)v.value("age"));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[]{"created"})));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[]{"knows"})));
                } else if (name.equals("ripple")) {
                    Assert.assertEquals((Object)"software", (Object)v.label());
                    Assert.assertEquals((Object)"java", (Object)v.value("lang"));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[]{"created"})));
                } else if (name.equals("peter")) {
                    Assert.assertEquals((Object)"person", (Object)v.label());
                    Assert.assertEquals((Object)35, (Object)v.value("age"));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v.edges(Direction.OUT, new String[]{"created"})));
                    Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)v.edges(Direction.IN, new String[0])));
                } else {
                    throw new IllegalStateException("The following vertex should not exist in the graph: " + name);
                }
            });
            Assert.assertEquals((double)3.5, (double)((Double)result.graph().traversal().E(new Object[0]).values(new String[]{"weight"}).sum().next()), (double)0.01);
            Assert.assertEquals((double)1.5, (double)((Double)result.graph().traversal().E(new Object[0]).hasLabel("knows", new String[0]).values(new String[]{"weight"}).sum().next()), (double)0.01);
            Assert.assertEquals((double)2.0, (double)((Double)result.graph().traversal().E(new Object[0]).hasLabel("created", new String[0]).values(new String[]{"weight"}).sum().next()), (double)0.01);
            Assert.assertEquals((long)result.memory().getIteration(), (long)0L);
            Assert.assertEquals((long)result.memory().asMap().size(), (long)0L);
        }
    }
}

