/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.remote.EmbeddedRemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Traversal.Exceptions.class, methods={"traversalIsLocked"}), @ExceptionCoverage(exceptionClass=Graph.Exceptions.class, methods={"idArgsMustBeEitherIdOrElement"})})
public class CoreTraversalTest
extends AbstractGremlinProcessTest {
    @Test
    @LoadGraphWith
    public void shouldNeverPropagateANoBulkTraverser() {
        Assert.assertFalse((boolean)this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).hasNext());
        Assert.assertEquals((long)0L, (long)this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).toList().size());
        this.g.V(new Object[0]).dedup(new String[0]).sideEffect(t -> t.asAdmin().setBulk(0L)).sideEffect(t -> Assert.fail((String)"this should not have happened")).iterate();
    }

    @Test
    @LoadGraphWith
    public void shouldNeverPropagateANullValuedTraverser() {
        Assert.assertFalse((boolean)this.g.V(new Object[0]).map(t -> null).hasNext());
        Assert.assertEquals((long)0L, (long)this.g.V(new Object[0]).map(t -> null).toList().size());
        this.g.V(new Object[0]).map(t -> null).sideEffect(t -> Assert.fail((String)"this should not have happened")).iterate();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadVerticesViaIds() {
        List vertices = this.g.V(new Object[0]).toList();
        List ids = vertices.stream().map(Element::id).collect(Collectors.toList());
        List verticesReloaded = this.g.V(ids.toArray()).toList();
        Assert.assertEquals((long)vertices.size(), (long)verticesReloaded.size());
        Assert.assertEquals(new HashSet(vertices), new HashSet(verticesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadEdgesViaIds() {
        List edges = this.g.E(new Object[0]).toList();
        List ids = edges.stream().map(Element::id).collect(Collectors.toList());
        List edgesReloaded = this.g.E(ids.toArray()).toList();
        Assert.assertEquals((long)edges.size(), (long)edgesReloaded.size());
        Assert.assertEquals(new HashSet(edges), new HashSet(edgesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadVerticesViaVertices() {
        List vertices = this.g.V(new Object[0]).toList();
        List verticesReloaded = this.g.V(vertices.toArray()).toList();
        Assert.assertEquals((long)vertices.size(), (long)verticesReloaded.size());
        Assert.assertEquals(new HashSet(vertices), new HashSet(verticesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldLoadEdgesViaEdges() {
        List edges = this.g.E(new Object[0]).toList();
        List edgesReloaded = this.g.E(edges.toArray()).toList();
        Assert.assertEquals((long)edges.size(), (long)edgesReloaded.size());
        Assert.assertEquals(new HashSet(edges), new HashSet(edgesReloaded));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowExceptionWhenIdsMixed() {
        List vertices = this.g.V(new Object[0]).toList();
        try {
            this.g.V(new Object[]{vertices.get(0), ((Vertex)vertices.get(1)).id()}).toList();
        }
        catch (Exception ex) {
            CoreTraversalTest.validateException(Graph.Exceptions.idArgsMustBeEitherIdOrElement(), ex);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveNextAndToCollectionWorkProperly() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)(traversal.next() instanceof Vertex));
        Assert.assertEquals((long)4L, (long)traversal.next(4).size());
        Assert.assertTrue((boolean)traversal.hasNext());
        Assert.assertTrue((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertFalse((boolean)traversal.tryNext().isPresent());
        Assert.assertFalse((boolean)traversal.hasNext());
        GraphTraversal intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        List list = intTraversal.toList();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)list.get(1)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(2)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)list.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(4)).intValue());
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        Set set = intTraversal.toSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(7));
        Assert.assertTrue((boolean)set.contains(2));
        Assert.assertTrue((boolean)set.contains(3));
        Assert.assertTrue((boolean)set.contains(6));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
        intTraversal = __.inject((Object[])new Integer[]{7, 7, 2, 3, 6});
        Assert.assertTrue((boolean)intTraversal.hasNext());
        BulkSet bulkSet = intTraversal.toBulkSet();
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertEquals((long)4L, (long)bulkSet.uniqueSize());
        Assert.assertEquals((long)5L, (long)bulkSet.longSize());
        Assert.assertEquals((long)5L, (long)bulkSet.size());
        Assert.assertTrue((boolean)bulkSet.contains((Object)7));
        Assert.assertTrue((boolean)bulkSet.contains((Object)2));
        Assert.assertTrue((boolean)bulkSet.contains((Object)3));
        Assert.assertTrue((boolean)bulkSet.contains((Object)6));
        Assert.assertEquals((long)2L, (long)bulkSet.get((Object)7));
        Assert.assertFalse((boolean)intTraversal.hasNext());
        Assert.assertFalse((boolean)intTraversal.tryNext().isPresent());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHavePropertyForEachRemainingBehaviorEvenWithStrategyRewrite() {
        GraphTraversal traversal = this.g.V(new Object[0]).out(new String[0]).groupCount();
        traversal.forEachRemaining(Map.class, map -> Assert.assertTrue((boolean)(map instanceof Map)));
    }

    @Test
    @Ignore
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotAlterTraversalAfterTraversalBecomesLocked() {
        GraphTraversal traversal = this.g.V(new Object[0]);
        Assert.assertTrue((boolean)traversal.hasNext());
        try {
            traversal.count().next();
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked()));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)Traversal.Exceptions.traversalIsLocked().getMessage(), (Object)e.getMessage());
        }
        catch (Exception e) {
            Assert.fail((String)("Should throw: " + Traversal.Exceptions.traversalIsLocked() + " not " + e + ":" + e.getMessage()));
        }
        traversal.iterate();
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfAutoTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.AUTO);
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTraverseIfManualTxEnabledAndOriginalTxIsClosed() {
        this.g.tx().onReadWrite((Consumer)Transaction.READ_WRITE_BEHAVIOR.MANUAL);
        this.g.tx().open();
        GraphTraversal t = this.g.V(new Object[0]).has("name", (Object)"marko");
        this.g.tx().rollback();
        this.g.tx().open();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)t));
        this.g.tx().rollback();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotThrowFastNoSuchElementException() {
        try {
            this.g.V(new Object[0]).has("foo").next();
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals(NoSuchElementException.class, e.getClass());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldThrowFastNoSuchElementExceptionInNestedTraversals() {
        GraphTraversal nestedTraversal = __.has((String)"name", (Object)"foo");
        GraphTraversal traversal = this.g.V(new Object[0]).has("name", (Object)"marko").branch((Traversal)nestedTraversal);
        GraphTraversal.Admin nestedTraversalAdmin = nestedTraversal.asAdmin();
        nestedTraversalAdmin.reset();
        nestedTraversalAdmin.addStart(nestedTraversalAdmin.getTraverserGenerator().generate(this.g.V(new Object[0]).has("name", (Object)"marko").next(), traversal.asAdmin().getStartStep(), 1L));
        try {
            nestedTraversal.next();
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals(FastNoSuchElementException.class, e.getClass());
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAllowEmbeddedRemoteConnectionUsage() {
        Graph remote = EmptyGraph.instance();
        GraphTraversalSource simulatedRemoteG = remote.traversal().withRemote((RemoteConnection)new EmbeddedRemoteConnection(this.g));
        Assert.assertEquals((long)6L, (long)((Long)simulatedRemoteG.V(new Object[0]).count().next()).intValue());
        Assert.assertEquals((Object)"marko", (Object)simulatedRemoteG.V(new Object[0]).has("name", (Object)"marko").values(new String[]{"name"}).next());
    }
}

