/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;
import org.junit.Assert;
import org.junit.Test;

public class StarGraphTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldHashAndEqualsCorrectly() {
        Vertex gremlin = (Vertex)this.g.V(new Object[]{this.convertToVertexId("gremlin")}).next();
        StarGraph gremlinStarGraph = StarGraph.of((Vertex)gremlin);
        StarGraph.StarVertex gremlinStar = gremlinStarGraph.getStarVertex();
        Vertex marko = (Vertex)this.g.V(new Object[]{this.convertToVertexId("marko")}).next();
        StarGraph markoStarGraph = StarGraph.of((Vertex)marko);
        StarGraph.StarAdjacentVertex gremlinStarAdjacentGraph = (StarGraph.StarAdjacentVertex)((Edge)IteratorUtils.filter((Iterator)markoStarGraph.getStarVertex().edges(Direction.OUT, new String[]{"uses"}), x -> x.inVertex().id().equals(this.convertToVertexId("gremlin"))).next()).inVertex();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            set.add(gremlin);
            set.add(gremlinStar);
            set.add(gremlinStarAdjacentGraph);
        }
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldValidateThatOriginalAndStarVerticesHaveTheSameTopology() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldSerializeCorrectlyUsingGryo() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, ((StarGraph)this.serializeDeserialize(StarGraph.of((Vertex)vertex)).getValue0()).getStarVertex()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    public void shouldAttachWithGetMethod() {
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex().attach(Attachable.Method.get((Host)vertex))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, ((Attachable)vertexProperty).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, ((Attachable)edge).attach(Attachable.Method.get((Host)vertex)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)vertex))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> TestHelper.validateEquality(vertex, StarGraph.of((Vertex)vertex).getStarVertex().attach(Attachable.Method.get((Host)this.graph))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> TestHelper.validateEquality(vertexProperty, ((Attachable)vertexProperty).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().properties(new String[0]).forEachRemaining(vertexProperty -> vertexProperty.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)this.graph))))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> TestHelper.validateEquality(edge, ((Attachable)edge).attach(Attachable.Method.get((Host)this.graph)))));
        this.g.V(new Object[0]).forEachRemaining(vertex -> StarGraph.of((Vertex)vertex).getStarVertex().edges(Direction.OUT, new String[0]).forEachRemaining(edge -> edge.properties(new String[0]).forEachRemaining(property -> TestHelper.validateEquality(property, ((Attachable)property).attach(Attachable.Method.get((Host)this.graph))))));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldCopyFromGraphAToGraphB() throws Exception {
        List starGraphs = IteratorUtils.stream((Iterator)this.graph.vertices(new Object[0])).map(StarGraph::of).collect(Collectors.toList());
        Configuration g1Configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), null);
        Graph g1 = this.graphProvider.openTestGraph(g1Configuration);
        starGraphs.stream().map(StarGraph::getStarVertex).forEach(vertex -> {
            Vertex cfr_ignored_0 = (Vertex)vertex.attach(Attachable.Method.getOrCreate((Host)g1));
        });
        starGraphs.stream().forEach(starGraph -> starGraph.edges(new Object[0]).forEachRemaining(edge -> {
            Edge cfr_ignored_0 = (Edge)((Attachable)edge).attach(Attachable.Method.getOrCreate((Host)g1));
        }));
        Assert.assertEquals((long)IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)g1.vertices(new Object[0])));
        Assert.assertEquals((long)IteratorUtils.count((Iterator)this.graph.edges(new Object[0])), (long)IteratorUtils.count((Iterator)g1.edges(new Object[0])));
        this.graph.vertices(new Object[0]).forEachRemaining(vertex -> TestHelper.validateVertexEquality(vertex, (Vertex)g1.vertices(new Object[]{vertex.id()}).next(), true));
        this.graphProvider.clear(g1, g1Configuration);
        Configuration g2Configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), null);
        Graph g2 = this.graphProvider.openTestGraph(g2Configuration);
        starGraphs.stream().forEach(starGraph -> starGraph.edges(new Object[0]).forEachRemaining(edge -> {
            Edge cfr_ignored_0 = (Edge)((Attachable)edge).attach(Attachable.Method.getOrCreate((Host)g2));
        }));
        Assert.assertEquals((long)IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)g2.vertices(new Object[0])));
        Assert.assertEquals((long)IteratorUtils.count((Iterator)this.graph.edges(new Object[0])), (long)IteratorUtils.count((Iterator)g2.edges(new Object[0])));
        this.graphProvider.clear(g2, g2Configuration);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="UserSuppliedIds"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void shouldAttachWithCreateMethod() {
        Random random = new Random(234335L);
        StarGraph starGraph = StarGraph.open();
        Vertex starVertex = starGraph.addVertex(new Object[]{T.label, "person", "name", "stephen", "name", "spmallete"});
        starVertex.property("acl", (Object)true, new Object[]{"timestamp", random.nextLong(), "creator", "marko"});
        for (int i = 0; i < 100; ++i) {
            starVertex.addEdge("knows", starGraph.addVertex(new Object[]{"person", "name", new UUID(random.nextLong(), random.nextLong()), "since", random.nextLong()}), new Object[0]);
            starGraph.addVertex(new Object[]{T.label, "project"}).addEdge("developedBy", starVertex, new Object[]{"public", random.nextBoolean()});
        }
        Vertex createdVertex = (Vertex)starGraph.getStarVertex().attach(Attachable.Method.create((Host)this.graph));
        starGraph.getStarVertex().edges(Direction.BOTH, new String[0]).forEachRemaining(edge -> {
            Edge cfr_ignored_0 = (Edge)((Attachable)edge).attach(Attachable.Method.create((Host)(random.nextBoolean() ? this.graph : createdVertex)));
        });
        TestHelper.validateEquality(starVertex, createdVertex);
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
    public void shouldHandleSelfLoops() {
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)this.graph.edges(new Object[0])));
        Vertex vertex = this.graph.addVertex("person");
        VertexProperty vertexProperty = vertex.property("name", (Object)"furnace");
        Edge edge = vertex.addEdge("self", vertex, new Object[0]);
        Property edgeProperty = edge.property("acl", (Object)"private");
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.graph.vertices(new Object[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)this.graph.edges(new Object[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)vertex.properties(new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)edge.properties(new String[0])));
        Assert.assertEquals((Object)vertexProperty, vertex.properties(new String[0]).next());
        Assert.assertEquals((Object)edgeProperty, edge.properties(new String[0]).next());
        StarGraph starGraph = StarGraph.of((Vertex)vertex);
        StarGraph.StarVertex starVertex = starGraph.getStarVertex();
        Edge starEdge = (Edge)starVertex.edges(Direction.OUT, new String[0]).next();
        Assert.assertEquals((Object)vertex, (Object)starVertex);
        Assert.assertEquals((Object)edge, (Object)starEdge);
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.properties(new String[0])));
        Assert.assertEquals((Object)"furnace", (Object)starVertex.value("name"));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.BOTH, new String[]{"self"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.OUT, new String[]{"self"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.IN, new String[]{"self"})));
        Iterator vertexIterator = starVertex.vertices(Direction.BOTH, new String[]{"self"});
        Assert.assertEquals((Object)starVertex, vertexIterator.next());
        Assert.assertEquals((Object)starVertex, vertexIterator.next());
        Assert.assertFalse((boolean)vertexIterator.hasNext());
        Assert.assertEquals((Object)starVertex, starVertex.vertices(Direction.OUT, new String[]{"self"}).next());
        Assert.assertEquals((Object)starVertex, starVertex.vertices(Direction.IN, new String[]{"self"}).next());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.BOTH, new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.OUT, new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.vertices(Direction.IN, new String[0])));
        vertexIterator = starVertex.vertices(Direction.BOTH, new String[0]);
        Assert.assertEquals((Object)starVertex, vertexIterator.next());
        Assert.assertEquals((Object)starVertex, vertexIterator.next());
        Assert.assertFalse((boolean)vertexIterator.hasNext());
        Assert.assertEquals((Object)starVertex, starVertex.vertices(Direction.OUT, new String[0]).next());
        Assert.assertEquals((Object)starVertex, starVertex.vertices(Direction.IN, new String[0]).next());
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)starVertex.edges(Direction.BOTH, new String[]{"self", "nothing"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.edges(Direction.OUT, new String[]{"self", "nothing"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)starVertex.edges(Direction.IN, new String[]{"self", "nothing"})));
        Iterator edgeIterator = starVertex.edges(Direction.BOTH, new String[]{"self", "nothing"});
        Edge tempEdge = (Edge)edgeIterator.next();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)tempEdge.properties(new String[0])));
        Assert.assertEquals((Object)"private", (Object)tempEdge.value("acl"));
        Assert.assertEquals((Object)starEdge, (Object)tempEdge);
        tempEdge = (Edge)edgeIterator.next();
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)tempEdge.properties(new String[0])));
        Assert.assertEquals((Object)"private", (Object)tempEdge.value("acl"));
        Assert.assertEquals((Object)starEdge, (Object)tempEdge);
        Assert.assertFalse((boolean)edgeIterator.hasNext());
        Assert.assertEquals((Object)starEdge, starVertex.edges(Direction.OUT, new String[]{"self", "nothing"}).next());
        Assert.assertEquals((Object)starEdge, starVertex.edges(Direction.IN, new String[]{"self", "nothing"}).next());
        StarGraph starGraphCopy = (StarGraph)this.serializeDeserialize(starGraph).getValue0();
        TestHelper.validateVertexEquality(vertex, (Vertex)starGraph.getStarVertex(), true);
        TestHelper.validateVertexEquality(vertex, (Vertex)starGraphCopy.getStarVertex(), true);
        TestHelper.validateVertexEquality((Vertex)starGraph.getStarVertex(), (Vertex)starGraphCopy.getStarVertex(), true);
        StarGraph starGraphNative = StarGraph.open();
        Vertex v1 = starGraphNative.addVertex(new Object[]{T.label, "thing", T.id, "v1"});
        Assert.assertEquals((Object)"v1", (Object)v1.id());
        Assert.assertEquals((Object)"thing", (Object)v1.label());
        Edge e1 = v1.addEdge("self", v1, new Object[]{"name", "pipes"});
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)v1.vertices(Direction.BOTH, new String[]{"self", "nothing"})));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v1.vertices(Direction.OUT, new String[0])));
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)v1.vertices(Direction.IN, new String[]{"self"})));
        edgeIterator = v1.edges(Direction.BOTH, new String[0]);
        TestHelper.validateEdgeEquality(e1, (Edge)edgeIterator.next());
        TestHelper.validateEdgeEquality(e1, (Edge)edgeIterator.next());
        Assert.assertFalse((boolean)edgeIterator.hasNext());
        TestHelper.validateEdgeEquality(e1, (Edge)v1.edges(Direction.OUT, new String[]{"self", "nothing"}).next());
        TestHelper.validateEdgeEquality(e1, (Edge)v1.edges(Direction.IN, new String[0]).next());
    }

    private Pair<StarGraph, Integer> serializeDeserialize(StarGraph starGraph) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((GryoIo)this.graph.io(IoCore.gryo())).writer().create().writeObject((OutputStream)outputStream, (Object)starGraph);
            return Pair.with((Object)((GryoIo)this.graph.io(IoCore.gryo())).reader().create().readObject((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), StarGraph.class), (Object)outputStream.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

