/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyCompilerGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.AbstractSession;
import org.apache.tinkerpop.gremlin.server.handler.Session;
import org.apache.tinkerpop.gremlin.server.handler.SessionException;
import org.apache.tinkerpop.gremlin.server.handler.SessionTask;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTaskSession
extends AbstractSession {
    private static final Logger logger = LoggerFactory.getLogger(MultiTaskSession.class);
    protected final BlockingQueue<SessionTask> queue;
    private final AtomicBoolean ending = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService;
    private final GremlinScriptEngineManager scriptEngineManager;
    private ScheduledFuture<?> requestCancelFuture;
    private Bindings bindings;

    public MultiTaskSession(SessionTask initialSessionTask, String sessionId, ConcurrentMap<String, Session> sessions) {
        super(initialSessionTask, sessionId, false, sessions);
        this.queue = new LinkedBlockingQueue<SessionTask>(initialSessionTask.getSettings().maxSessionTaskQueueSize);
        this.scriptEngineManager = initialSessionTask.getSettings().useCommonEngineForSessions ? initialSessionTask.getGremlinExecutor().getScriptEngineManager() : this.initializeGremlinExecutor(initialSessionTask).getScriptEngineManager();
        this.scheduledExecutorService = initialSessionTask.getScheduledExecutorService();
        if (!this.submitTask(initialSessionTask)) {
            logger.error("Task {} rejected on creation of the {} for session {}", new Object[]{initialSessionTask.getRequestMessage().getRequestId(), this.getClass().getSimpleName(), this.getSessionId()});
            String msg = String.format("Task %s rejected from session %s", initialSessionTask.getRequestMessage().getRequestId(), this.getSessionId());
            throw new RejectedExecutionException(msg);
        }
    }

    @Override
    public GremlinScriptEngine getScriptEngine(SessionTask sessionTask, String language) {
        return this.scriptEngineManager.getEngineByName(language);
    }

    @Override
    public boolean isAcceptingTasks() {
        return !this.ending.get();
    }

    @Override
    public boolean submitTask(SessionTask sessionTask) throws RejectedExecutionException {
        try {
            return this.isAcceptingTasks() && this.queue.add(sessionTask);
        }
        catch (IllegalStateException ise) {
            String msg = String.format("Task %s rejected from session %s", sessionTask.getRequestMessage().getRequestId(), this.getSessionId());
            throw new RejectedExecutionException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.sessionThread = Thread.currentThread();
        SessionTask sessionTask = (SessionTask)this.queue.poll();
        if (null == sessionTask) {
            throw new IllegalStateException(String.format("Worker has no initial context for session: %s", this.getSessionId()));
        }
        try {
            this.startTransaction(sessionTask);
            try {
                while (true) {
                    long seto = sessionTask.getRequestTimeout();
                    this.requestCancelFuture = this.scheduledExecutorService.schedule(() -> this.triggerTimeout(seto, false), seto, TimeUnit.MILLISECONDS);
                    try {
                        this.process(sessionTask);
                    }
                    catch (SessionException ex) {
                        if (!this.maintainStateAfterException || this.closeReason.get() == AbstractSession.CloseReason.CHANNEL_CLOSED || this.closeReason.get() == AbstractSession.CloseReason.SESSION_TIMEOUT) {
                            throw ex;
                        }
                        this.closeReason.set(null);
                        logger.warn(ex.getMessage(), (Throwable)ex);
                        sessionTask.writeAndFlush(ex.getResponseMessage());
                    }
                    this.cancelRequestTimeout();
                    sessionTask = this.queue.take();
                }
            }
            catch (Exception ex) {
                this.stopAcceptingRequests();
                this.handleException(sessionTask, ex);
                if (this.closeReason.compareAndSet(null, AbstractSession.CloseReason.EXIT_PROCESSING) || this.closeReason.get() == AbstractSession.CloseReason.PROCESSING_EXCEPTION || this.closeReason.get() == AbstractSession.CloseReason.SESSION_TIMEOUT) {
                    this.close();
                }
            }
        }
        catch (SessionException rexex) {
            this.closeReason.compareAndSet(null, AbstractSession.CloseReason.PROCESSING_EXCEPTION);
            for (SessionTask st : this.queue) {
                st.writeAndFlush(ResponseStatusCode.PARTIAL_CONTENT, ResponseMessage.build((RequestMessage)st.getRequestMessage()).code(ResponseStatusCode.SERVER_ERROR).statusMessage(String.format("An earlier request [%s] failed prior to this one having a chance to execute", sessionTask.getRequestMessage().getRequestId())).create());
            }
            this.closeTransactionSafely(Transaction.Status.ROLLBACK);
            if (!sessionTask.isFinalResponseWritten()) {
                logger.warn(rexex.getMessage(), (Throwable)rexex);
                sessionTask.writeAndFlush(rexex.getResponseMessage());
            }
        }
        finally {
            if (this.closeReason.compareAndSet(null, AbstractSession.CloseReason.EXIT_PROCESSING) || this.closeReason.get() == AbstractSession.CloseReason.PROCESSING_EXCEPTION || this.closeReason.get() == AbstractSession.CloseReason.SESSION_TIMEOUT) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        this.stopAcceptingRequests();
        this.cancelRequestTimeout();
        super.close();
        logger.debug("Session {} closed", (Object)this.getSessionId());
    }

    private void cancelRequestTimeout() {
        if (this.requestCancelFuture != null && !this.requestCancelFuture.isDone()) {
            this.requestCancelFuture.cancel(true);
        } else {
            logger.debug("Could not cancel request timeout for {} - {}", (Object)this.getSessionId(), this.requestCancelFuture);
        }
    }

    private void stopAcceptingRequests() {
        if (this.ending.compareAndSet(false, true)) {
            this.cancel(true);
        }
    }

    @Override
    protected Bindings getWorkerBindings() throws SessionException {
        if (null == this.bindings) {
            this.bindings = super.getWorkerBindings();
        }
        return this.bindings;
    }

    protected GremlinExecutor initializeGremlinExecutor(SessionTask sessionTask) {
        Settings settings = sessionTask.getSettings();
        ExecutorService executor = sessionTask.getGremlinExecutor().getExecutorService();
        boolean useGlobalFunctionCache = settings.useGlobalFunctionCacheForSessions;
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().evaluationTimeout(settings.getEvaluationTimeout()).executorService(executor).globalBindings(this.graphManager.getAsBindings()).scheduledExecutorService(this.scheduledExecutorService);
        settings.scriptEngines.forEach((k, v) -> {
            if (!v.plugins.isEmpty()) {
                if (v.plugins.containsKey(GroovyCompilerGremlinPlugin.class.getName())) {
                    v.plugins.get(GroovyCompilerGremlinPlugin.class.getName()).put("globalFunctionCacheEnabled", useGlobalFunctionCache);
                } else {
                    HashMap<String, Boolean> pluginConf = new HashMap<String, Boolean>();
                    pluginConf.put("globalFunctionCacheEnabled", useGlobalFunctionCache);
                    v.plugins.put(GroovyCompilerGremlinPlugin.class.getName(), pluginConf);
                }
                gremlinExecutorBuilder.addPlugins(k, v.plugins);
            }
        });
        return gremlinExecutorBuilder.create();
    }

    public String toString() {
        return String.format("%s - session: %s", MultiTaskSession.class.getSimpleName(), this.getSessionId());
    }
}

