/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.GremlinResponseFrameEncoder;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinBinaryRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinCloseRequestDecoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinResponseFrameEncoder;
import org.apache.tinkerpop.gremlin.server.handler.WsGremlinTextRequestDecoder;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketChannelizer.class);
    private GremlinResponseFrameEncoder gremlinResponseFrameEncoder;
    private WsGremlinTextRequestDecoder wsGremlinTextRequestDecoder;
    private WsGremlinBinaryRequestDecoder wsGremlinBinaryRequestDecoder;
    private WsGremlinResponseFrameEncoder wsGremlinResponseFrameEncoder;
    private WsGremlinCloseRequestDecoder wsGremlinCloseRequestDecoder;
    private AbstractAuthenticationHandler authenticationHandler;

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.gremlinResponseFrameEncoder = new GremlinResponseFrameEncoder();
        this.wsGremlinTextRequestDecoder = new WsGremlinTextRequestDecoder(this.serializers);
        this.wsGremlinBinaryRequestDecoder = new WsGremlinBinaryRequestDecoder(this.serializers);
        this.wsGremlinCloseRequestDecoder = new WsGremlinCloseRequestDecoder(this.serializers);
        this.wsGremlinResponseFrameEncoder = new WsGremlinResponseFrameEncoder();
        if (this.authenticator != null) {
            this.authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : this.instantiateAuthenticationHandler(this.settings.authentication);
        }
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        logger.debug("HttpRequestDecoder settings - maxInitialLineLength={}, maxHeaderSize={}, maxChunkSize={}", new Object[]{this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize});
        pipeline.addLast("http-request-decoder", (ChannelHandler)new HttpRequestDecoder(this.settings.maxInitialLineLength, this.settings.maxHeaderSize, this.settings.maxChunkSize));
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-decoder-aggregator", LogLevel.DEBUG)});
        }
        logger.debug("HttpObjectAggregator settings - maxContentLength={}, maxAccumulationBufferComponents={}", (Object)this.settings.maxContentLength, (Object)this.settings.maxAccumulationBufferComponents);
        HttpObjectAggregator aggregator = new HttpObjectAggregator(this.settings.maxContentLength);
        aggregator.setMaxCumulationBufferComponents(this.settings.maxAccumulationBufferComponents);
        pipeline.addLast("aggregator", (ChannelHandler)aggregator);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-response-encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("request-handler", (ChannelHandler)new WebSocketServerProtocolHandler("/gremlin", null, false, this.settings.maxContentLength));
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        pipeline.addLast("ws-frame-encoder", (ChannelHandler)this.wsGremlinResponseFrameEncoder);
        pipeline.addLast("response-frame-encoder", (ChannelHandler)this.gremlinResponseFrameEncoder);
        pipeline.addLast("request-text-decoder", (ChannelHandler)this.wsGremlinTextRequestDecoder);
        pipeline.addLast("request-binary-decoder", (ChannelHandler)this.wsGremlinBinaryRequestDecoder);
        pipeline.addLast("request-close-decoder", (ChannelHandler)this.wsGremlinCloseRequestDecoder);
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-aggregator-encoder", LogLevel.DEBUG)});
        }
        if (this.authenticationHandler != null) {
            pipeline.addLast("authenticator", (ChannelHandler)this.authenticationHandler);
        }
    }

    @Override
    public boolean supportsIdleMonitor() {
        return true;
    }

    @Override
    public Object createIdleDetectionMessage() {
        return new PingWebSocketFrame();
    }

    private AbstractAuthenticationHandler instantiateAuthenticationHandler(Settings.AuthenticationSettings authSettings) {
        String authenticationHandler = authSettings.authenticationHandler;
        if (authenticationHandler == null) {
            return new SaslAuthenticationHandler(this.authenticator);
        }
        return this.createAuthenticationHandler(authSettings);
    }
}

