/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.engine.ScriptEngines;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGremlinExecutor<T extends ScheduledExecutorService> {
    private static final Logger logger = LoggerFactory.getLogger(ServerGremlinExecutor.class);
    private final GraphManager graphManager;
    private final Settings settings;
    private final List<LifeCycleHook> hooks;
    private final T scheduledExecutorService;
    private final ExecutorService gremlinExecutorService;
    private final GremlinExecutor gremlinExecutor;
    private final Map<String, Object> hostOptions = new ConcurrentHashMap<String, Object>();

    public ServerGremlinExecutor(Settings settings, Class<T> scheduleExecutorServiceClass) {
        this(settings, null, null, scheduleExecutorServiceClass);
    }

    public ServerGremlinExecutor(Settings settings, ExecutorService gremlinExecutorService, T scheduledExecutorService, Class<T> scheduleExecutorServiceClass) {
        this(settings, gremlinExecutorService, scheduledExecutorService, scheduleExecutorServiceClass, null);
    }

    public ServerGremlinExecutor(Settings settings, ExecutorService gremlinExecutorService, T scheduledExecutorService, Class<T> scheduleExecutorServiceClass, GraphManager graphManager) {
        ThreadFactory threadFactoryGremlin;
        this.settings = settings;
        if (null == graphManager) {
            try {
                Class<?> clazz = Class.forName(settings.graphManager);
                Constructor<?> c = clazz.getConstructor(Settings.class);
                graphManager = (GraphManager)c.newInstance(settings);
            }
            catch (ClassNotFoundException e2) {
                logger.error("Could not find GraphManager implementation defined by the 'graphManager' setting as: {}", (Object)settings.graphManager);
                throw new RuntimeException(e2);
            }
            catch (Exception e3) {
                logger.error("Could not invoke constructor on class {} (defined by the 'graphManager' setting) with one argument of class Settings", (Object)settings.graphManager);
                throw new RuntimeException(e3);
            }
        }
        if (null == gremlinExecutorService) {
            threadFactoryGremlin = ThreadFactoryUtil.create("exec-%d");
            this.gremlinExecutorService = Executors.newFixedThreadPool(settings.gremlinPool, threadFactoryGremlin);
        } else {
            this.gremlinExecutorService = gremlinExecutorService;
        }
        if (null == scheduledExecutorService) {
            threadFactoryGremlin = ThreadFactoryUtil.create("worker-%d");
            this.scheduledExecutorService = (ScheduledExecutorService)scheduleExecutorServiceClass.cast(Executors.newScheduledThreadPool(settings.threadPoolWorker, threadFactoryGremlin));
        } else {
            this.scheduledExecutorService = scheduledExecutorService;
        }
        this.graphManager = graphManager;
        logger.info("Initialized Gremlin thread pool.  Threads in pool named with pattern gremlin-*");
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().scriptEvaluationTimeout(settings.scriptEvaluationTimeout).afterFailure((b, e) -> this.graphManager.rollbackAll()).beforeEval(b -> this.graphManager.rollbackAll()).afterTimeout(b -> this.graphManager.rollbackAll()).enabledPlugins(new HashSet<String>(settings.plugins)).globalBindings(this.graphManager.getAsBindings()).executorService(this.gremlinExecutorService).scheduledExecutorService(this.scheduledExecutorService);
        settings.scriptEngines.forEach((k, v) -> {
            if (v.plugins.isEmpty()) {
                v.imports.add(LifeCycleHook.class.getCanonicalName());
                v.imports.add(LifeCycleHook.Context.class.getCanonicalName());
                gremlinExecutorBuilder.addEngineSettings(k, v.imports, v.staticImports, v.scripts, v.config);
            } else {
                gremlinExecutorBuilder.addPlugins(k, v.plugins);
            }
        });
        this.gremlinExecutor = gremlinExecutorBuilder.create();
        logger.info("Initialized GremlinExecutor and preparing GremlinScriptEngines instances.");
        settings.scriptEngines.keySet().forEach(engineName -> {
            try {
                this.gremlinExecutor.eval("1+1", engineName, Collections.emptyMap()).join();
                this.registerMetrics((String)engineName);
                logger.info("Initialized {} GremlinScriptEngine and registered metrics", engineName);
            }
            catch (Exception ex) {
                logger.warn(String.format("Could not initialize %s GremlinScriptEngine as init script could not be evaluated", engineName), (Throwable)ex);
            }
        });
        this.gremlinExecutor.getGlobalBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof Graph).forEach(kv -> this.graphManager.putGraph((String)kv.getKey(), (Graph)kv.getValue()));
        this.gremlinExecutor.getGlobalBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof TraversalSource).forEach(kv -> {
            logger.info("A {} is now bound to [{}] with {}", new Object[]{kv.getValue().getClass().getSimpleName(), kv.getKey(), kv.getValue()});
            this.graphManager.putTraversalSource((String)kv.getKey(), (TraversalSource)kv.getValue());
        });
        this.hooks = this.gremlinExecutor.getGlobalBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof LifeCycleHook).map(kv -> (LifeCycleHook)kv.getValue()).collect(Collectors.toList());
    }

    private void registerMetrics(String engineName) {
        ScriptEngines scriptEngines = this.gremlinExecutor.getScriptEngines();
        GremlinScriptEngine engine = null == scriptEngines ? this.gremlinExecutor.getScriptEngineManager().getEngineByName(engineName) : scriptEngines.getEngineByName(engineName);
        MetricManager.INSTANCE.registerGremlinScriptEngineMetrics(engine, engineName, "sessionless", "class-cache");
    }

    public void addHostOption(String key, Object value) {
        this.hostOptions.put(key, value);
    }

    public Map<String, Object> getHostOptions() {
        return Collections.unmodifiableMap(this.hostOptions);
    }

    public Object removeHostOption(String key) {
        return this.hostOptions.remove(key);
    }

    public void clearHostOptions() {
        this.hostOptions.clear();
    }

    public T getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public ExecutorService getGremlinExecutorService() {
        return this.gremlinExecutorService;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<LifeCycleHook> getHooks() {
        return this.hooks;
    }
}

