/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.List;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.session.Session;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WsGremlinResponseEncoder
extends MessageToMessageEncoder<ResponseMessage> {
    private static final Logger logger = LoggerFactory.getLogger(WsGremlinResponseEncoder.class);
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));

    protected void encode(ChannelHandlerContext ctx, ResponseMessage o, List<Object> objects) throws Exception {
        MessageSerializer serializer = (MessageSerializer)ctx.channel().attr(StateKey.SERIALIZER).get();
        boolean useBinary = (Boolean)ctx.channel().attr(StateKey.USE_BINARY).get();
        Session session = (Session)ctx.channel().attr(StateKey.SESSION).get();
        try {
            if (!o.getStatus().getCode().isSuccess()) {
                errorMeter.mark();
            }
            if (useBinary) {
                ByteBuf serialized = null == session ? serializer.serializeResponseAsBinary(o, ctx.alloc()) : session.getExecutor().submit(() -> serializer.serializeResponseAsBinary(o, ctx.alloc())).get();
                objects.add(new BinaryWebSocketFrame(serialized));
            } else {
                MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
                String serialized = null == session ? textSerializer.serializeResponseAsString(o) : session.getExecutor().submit(() -> textSerializer.serializeResponseAsString(o)).get();
                objects.add(new TextWebSocketFrame(true, 0, serialized));
            }
        }
        catch (Exception ex) {
            errorMeter.mark();
            logger.warn("The result [{}] in the request {} could not be serialized and returned.", new Object[]{o.getResult(), o.getRequestId(), ex});
            String errorMessage = String.format("Error during serialization: %s", ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
            ResponseMessage error = ResponseMessage.build((UUID)o.getRequestId()).statusMessage(errorMessage).code(ResponseStatusCode.SERVER_ERROR_SERIALIZATION).create();
            if (useBinary) {
                objects.add(new BinaryWebSocketFrame(serializer.serializeResponseAsBinary(error, ctx.alloc())));
            }
            MessageTextSerializer textSerializer = (MessageTextSerializer)serializer;
            objects.add(new TextWebSocketFrame(textSerializer.serializeResponseAsString(error)));
        }
    }
}

