/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.server.Channelizer;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.IteratorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpExecutorHandler;
import org.apache.tinkerpop.gremlin.server.handler.OpSelectorHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelizer
extends ChannelInitializer<SocketChannel>
implements Channelizer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelizer.class);
    protected Settings settings;
    protected GremlinExecutor gremlinExecutor;
    protected Optional<SslContext> sslContext;
    protected GraphManager graphManager;
    protected ExecutorService gremlinExecutorService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected static final String PIPELINE_SSL = "ssl";
    protected static final String PIPELINE_OP_SELECTOR = "op-selector";
    protected static final String PIPELINE_RESULT_ITERATOR_HANDLER = "result-iterator-handler";
    protected static final String PIPELINE_OP_EXECUTOR = "op-executor";
    protected final Map<String, MessageSerializer> serializers = new HashMap<String, MessageSerializer>();
    private OpSelectorHandler opSelectorHandler;
    private OpExecutorHandler opExecutorHandler;
    private IteratorHandler iteratorHandler;

    public abstract void configure(ChannelPipeline var1);

    public void finalize(ChannelPipeline pipeline) {
    }

    @Override
    public void init(ServerGremlinExecutor<EventLoopGroup> serverGremlinExecutor) {
        this.settings = serverGremlinExecutor.getSettings();
        this.gremlinExecutor = serverGremlinExecutor.getGremlinExecutor();
        this.graphManager = serverGremlinExecutor.getGraphManager();
        this.gremlinExecutorService = serverGremlinExecutor.getGremlinExecutorService();
        this.scheduledExecutorService = serverGremlinExecutor.getScheduledExecutorService();
        this.configureSerializers();
        Optional<Object> optional = this.sslContext = this.settings.optionalSsl().isPresent() && this.settings.ssl.enabled ? Optional.ofNullable(this.createSSLContext(this.settings)) : Optional.empty();
        if (this.sslContext.isPresent()) {
            logger.info("SSL enabled");
        }
        this.opSelectorHandler = new OpSelectorHandler(this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
        this.opExecutorHandler = new OpExecutorHandler(this.settings, this.graphManager, this.gremlinExecutor, this.scheduledExecutorService);
        this.iteratorHandler = new IteratorHandler(this.settings);
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslContext.isPresent()) {
            pipeline.addLast(PIPELINE_SSL, (ChannelHandler)this.sslContext.get().newHandler(ch.alloc()));
        }
        this.configure(pipeline);
        pipeline.addLast(PIPELINE_OP_SELECTOR, (ChannelHandler)this.opSelectorHandler);
        pipeline.addLast(PIPELINE_RESULT_ITERATOR_HANDLER, (ChannelHandler)this.iteratorHandler);
        pipeline.addLast(PIPELINE_OP_EXECUTOR, (ChannelHandler)this.opExecutorHandler);
        this.finalize(pipeline);
    }

    private void configureSerializers() {
        this.settings.serializers.stream().map(config -> {
            try {
                Class<?> clazz = Class.forName(config.className);
                if (!MessageSerializer.class.isAssignableFrom(clazz)) {
                    logger.warn("The {} serialization class does not implement {} - it will not be available.", (Object)config.className, (Object)MessageSerializer.class.getCanonicalName());
                    return Optional.empty();
                }
                MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
                if (config.config != null) {
                    serializer.configure(config.config, this.graphManager.getGraphs());
                }
                return Optional.ofNullable(serializer);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Could not find configured serializer class - {} - it will not be available", (Object)config.className);
                return Optional.empty();
            }
            catch (Exception ex) {
                logger.warn("Could not instantiate configured serializer class - {} - it will not be available. {}", (Object)config.className, (Object)ex.getMessage());
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).flatMap(serializer -> Stream.of(serializer.mimeTypesSupported()).map(mimeType -> Pair.with((Object)mimeType, (Object)serializer))).forEach(pair -> {
            String mimeType = (String)pair.getValue0();
            MessageSerializer serializer = (MessageSerializer)pair.getValue1();
            if (this.serializers.containsKey(mimeType)) {
                logger.warn("{} already has {} configured.  It will not be replaced by {}. Check configuration for serializer duplication or other issues.", new Object[]{mimeType, this.serializers.get(mimeType).getClass().getName(), serializer.getClass().getName()});
            } else {
                logger.info("Configured {} with {}", (Object)mimeType, (Object)((MessageSerializer)pair.getValue1()).getClass().getName());
                this.serializers.put(mimeType, serializer);
            }
        });
        if (this.serializers.size() == 0) {
            logger.error("No serializers were successfully configured - server will not start.");
            throw new RuntimeException("Serialization configuration error.");
        }
    }

    private SslContext createSSLContext(Settings settings) {
        SslContextBuilder builder;
        Settings.SslSettings sslSettings = settings.ssl;
        SslProvider provider = SslProvider.JDK;
        if (null == sslSettings.keyCertChainFile || null == sslSettings.keyFile) {
            try {
                logger.warn("Enabling SSL with self-signed certificate (NOT SUITABLE FOR PRODUCTION)");
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                builder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
            }
            catch (CertificateException ce) {
                logger.error("There was an error creating the self-signed certificate for SSL - SSL is not enabled", (Throwable)ce);
                return null;
            }
        } else {
            File keyCertChainFile = new File(sslSettings.keyCertChainFile);
            File keyFile = new File(sslSettings.keyFile);
            File trustCertChainFile = null == sslSettings.trustCertChainFile ? null : new File(sslSettings.trustCertChainFile);
            builder = SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)sslSettings.keyPassword).trustManager(trustCertChainFile);
        }
        builder.sslProvider(provider);
        try {
            return builder.build();
        }
        catch (SSLException ssle) {
            logger.error("There was an error enabling SSL", (Throwable)ssle);
            return null;
        }
    }
}

