/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerGremlinV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV2d0;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoLiteMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;

public enum Serializers {
    GRAPHSON("application/json"),
    GRAPHSON_V1D0("application/vnd.gremlin-v1.0+json"),
    GRAPHSON_V2D0("application/vnd.gremlin-v2.0+json"),
    GRAPHSON_V3D0("application/vnd.gremlin-v3.0+json"),
    GRAPHBINARY_V1D0("application/vnd.graphbinary-v1.0"),
    GRYO_V1D0("application/vnd.gremlin-v1.0+gryo"),
    GRYO_V3D0("application/vnd.gremlin-v3.0+gryo"),
    GRYO_LITE_V1D0("application/vnd.gremlin-v1.0+gryo-lite");

    private String value;
    @Deprecated
    public static final MessageSerializer DEFAULT_RESULT_SERIALIZER;
    @Deprecated
    public static final MessageSerializer DEFAULT_REQUEST_SERIALIZER;

    private Serializers(String mimeType) {
        this.value = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public MessageSerializer simpleInstance() {
        switch (this.value) {
            case "application/json": {
                return new GraphSONMessageSerializerV3d0();
            }
            case "application/vnd.gremlin-v1.0+json": {
                return new GraphSONMessageSerializerGremlinV1d0();
            }
            case "application/vnd.gremlin-v2.0+json": {
                return new GraphSONMessageSerializerV2d0();
            }
            case "application/vnd.gremlin-v3.0+json": {
                return new GraphSONMessageSerializerV3d0();
            }
            case "application/vnd.gremlin-v1.0+gryo": {
                return new GryoMessageSerializerV1d0();
            }
            case "application/vnd.gremlin-v3.0+gryo": {
                return new GryoMessageSerializerV3d0();
            }
            case "application/vnd.gremlin-v1.0+gryo-lite": {
                return new GryoLiteMessageSerializerV1d0();
            }
            case "application/vnd.graphbinary-v1.0": {
                return new GraphBinaryMessageSerializerV1();
            }
        }
        throw new RuntimeException("Could not create a simple MessageSerializer instance of " + this.value);
    }

    static {
        DEFAULT_RESULT_SERIALIZER = new GraphSONMessageSerializerV1d0();
        DEFAULT_REQUEST_SERIALIZER = new GraphSONMessageSerializerV1d0();
    }
}

