/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class CharSerializer
extends SimpleTypeSerializer<Character> {
    public CharSerializer() {
        super(DataType.CHAR);
    }

    @Override
    protected Character readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        byte[] byteArray;
        int firstByte = buffer.readByte() & 0xFF;
        int byteLength = 1;
        if ((firstByte & 0x80) > 0) {
            if ((firstByte & 0xF0) == 240) {
                byteLength = 4;
            } else if ((firstByte & 0xE0) == 224) {
                byteLength = 3;
            } else if ((firstByte & 0xC0) == 192) {
                byteLength = 2;
            }
        }
        if (byteLength == 1) {
            byteArray = new byte[]{(byte)firstByte};
        } else {
            byteArray = new byte[byteLength];
            byteArray[0] = (byte)firstByte;
            buffer.readBytes(byteArray, 1, byteLength - 1);
        }
        return Character.valueOf(new String(byteArray, StandardCharsets.UTF_8).charAt(0));
    }

    @Override
    protected void writeValue(Character value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        String stringValue = Character.toString(value.charValue());
        buffer.writeBytes(stringValue.getBytes(StandardCharsets.UTF_8));
    }
}

