/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.javatuples.Pair;

final class ResultQueue {
    private final LinkedBlockingQueue<Result> resultLinkedBlockingQueue;
    private Object aggregatedResult = null;
    private final AtomicReference<Throwable> error = new AtomicReference();
    private final CompletableFuture<Void> readComplete;
    private final Queue<Pair<CompletableFuture<List<Result>>, Integer>> waiting = new ConcurrentLinkedQueue<Pair<CompletableFuture<List<Result>>, Integer>>();
    private Map<String, Object> statusAttributes = null;

    public ResultQueue(LinkedBlockingQueue<Result> resultLinkedBlockingQueue, CompletableFuture<Void> readComplete) {
        this.resultLinkedBlockingQueue = resultLinkedBlockingQueue;
        this.readComplete = readComplete;
    }

    public void add(Result result) {
        this.resultLinkedBlockingQueue.offer(result);
        this.tryDrainNextWaiting(false);
    }

    @Deprecated
    public void addSideEffect(String aggregateTo, Object sideEffectValue) {
        switch (aggregateTo) {
            case "bulkset": {
                if (!(sideEffectValue instanceof Traverser.Admin)) {
                    throw new IllegalStateException(String.format("Side-effect value %s is a %s which does not aggregate to %s", sideEffectValue, sideEffectValue.getClass().getSimpleName(), aggregateTo));
                }
                if (null == this.aggregatedResult) {
                    this.aggregatedResult = new BulkSet();
                }
                BulkSet bs = (BulkSet)this.validate(aggregateTo, BulkSet.class);
                Traverser.Admin traverser = (Traverser.Admin)sideEffectValue;
                bs.add(traverser.get(), traverser.bulk());
                break;
            }
            case "list": {
                if (null == this.aggregatedResult) {
                    this.aggregatedResult = new ArrayList();
                }
                List list = (List)this.validate(aggregateTo, List.class);
                list.add(sideEffectValue);
                break;
            }
            case "set": {
                if (null == this.aggregatedResult) {
                    this.aggregatedResult = new HashSet();
                }
                Set set = (Set)this.validate(aggregateTo, Set.class);
                set.add(sideEffectValue);
                break;
            }
            case "map": {
                if (!(sideEffectValue instanceof Map.Entry) && !(sideEffectValue instanceof Map)) {
                    throw new IllegalStateException(String.format("Side-effect value %s is a %s which does not aggregate to %s", sideEffectValue, sideEffectValue.getClass().getSimpleName(), aggregateTo));
                }
                if (sideEffectValue instanceof Map && ((Map)sideEffectValue).size() != 1) {
                    throw new IllegalStateException(String.format("Side-effect value %s is a %s which does not aggregate to %s as it is a Map that does not have one entry", sideEffectValue, sideEffectValue.getClass().getSimpleName(), aggregateTo));
                }
                if (null == this.aggregatedResult) {
                    this.aggregatedResult = new HashMap();
                }
                Map m = (Map)this.validate(aggregateTo, Map.class);
                Map.Entry entry = sideEffectValue instanceof Map.Entry ? (Map.Entry)sideEffectValue : ((Map)sideEffectValue).entrySet().iterator().next();
                m.put(entry.getKey(), entry.getValue());
                break;
            }
            case "none": {
                if (null != this.aggregatedResult) break;
                this.aggregatedResult = sideEffectValue;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("%s is an invalid value for %s", aggregateTo, "aggregateTo"));
            }
        }
    }

    private <V> V validate(String aggregateTo, Class<?> expected) {
        if (!expected.isAssignableFrom(this.aggregatedResult.getClass())) {
            throw new IllegalStateException(String.format("Side-effect \"%s\" contains the type %s that is not acceptable for %s", this.aggregatedResult.getClass().getSimpleName(), aggregateTo));
        }
        return (V)this.aggregatedResult;
    }

    public CompletableFuture<List<Result>> await(int items) {
        CompletableFuture<List<Result>> result = new CompletableFuture<List<Result>>();
        this.waiting.add((Pair<CompletableFuture<List<Result>>, Integer>)Pair.with(result, (Object)items));
        this.tryDrainNextWaiting(false);
        return result;
    }

    public int size() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.resultLinkedBlockingQueue.size();
    }

    public boolean isEmpty() {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        return this.size() == 0;
    }

    public boolean isComplete() {
        return this.readComplete.isDone();
    }

    void drainTo(Collection<Result> collection) {
        if (this.error.get() != null) {
            throw new RuntimeException(this.error.get());
        }
        this.resultLinkedBlockingQueue.drainTo(collection);
    }

    void markComplete(Map<String, Object> statusAttributes) {
        if (this.aggregatedResult != null) {
            this.add(new Result(this.aggregatedResult));
        }
        this.statusAttributes = null == statusAttributes ? Collections.emptyMap() : statusAttributes;
        this.readComplete.complete(null);
        this.drainAllWaiting();
    }

    void markError(Throwable throwable) {
        this.error.set(throwable);
        this.readComplete.completeExceptionally(throwable);
        this.drainAllWaiting();
    }

    Map<String, Object> getStatusAttributes() {
        return this.statusAttributes;
    }

    private synchronized void tryDrainNextWaiting(boolean force) {
        Pair<CompletableFuture<List<Result>>, Integer> nextWaiting = this.waiting.peek();
        if (nextWaiting != null && (force || this.resultLinkedBlockingQueue.size() >= (Integer)nextWaiting.getValue1() || this.readComplete.isDone())) {
            int items = (Integer)nextWaiting.getValue1();
            CompletableFuture future = (CompletableFuture)nextWaiting.getValue0();
            ArrayList results = new ArrayList(items);
            this.resultLinkedBlockingQueue.drainTo(results, items);
            if (null == this.error.get()) {
                future.complete(results);
            } else {
                future.completeExceptionally(this.error.get());
            }
            this.waiting.remove(nextWaiting);
        }
    }

    private void drainAllWaiting() {
        while (!this.waiting.isEmpty()) {
            this.tryDrainNextWaiting(true);
        }
    }
}

