/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class OffsetTimeSerializer
extends SimpleTypeSerializer<OffsetTime> {
    public OffsetTimeSerializer() {
        super(DataType.OFFSETTIME);
    }

    @Override
    protected OffsetTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        LocalTime ldt = context.readValue(buffer, LocalTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return OffsetTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(OffsetTime value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.toLocalTime(), buffer, false);
        context.writeValue(value.getOffset(), buffer, false);
    }
}

