/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class InetAddressSerializer<T extends InetAddress>
extends SimpleTypeSerializer<T> {
    public InetAddressSerializer() {
        super(DataType.INETADDRESS);
    }

    @Override
    protected T readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        try {
            return (T)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new SerializationException("Cannot deserialize InetAddress value", uhe);
        }
    }

    @Override
    protected void writeValue(T value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        byte[] bytes = ((InetAddress)value).getAddress();
        buffer.writeInt(bytes.length).writeBytes(bytes);
    }
}

