/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ByteBufferSerializer
extends SimpleTypeSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(DataType.BYTEBUFFER);
    }

    @Override
    protected ByteBuffer readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        ByteBuffer bb = ByteBuffer.allocate(buffer.readInt());
        buffer.readBytes(bb);
        bb.rewind();
        return bb;
    }

    @Override
    protected void writeValue(ByteBuffer value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        byte[] bytes = value.array();
        buffer.writeInt(bytes.length).writeBytes(bytes);
    }
}

