/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketClientHandler
extends WebSocketClientProtocolHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final long connectionSetupTimeoutMillis;
    private ChannelPromise handshakeFuture;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, long timeoutMillis) {
        super(handshaker, true, true, timeoutMillis);
        this.connectionSetupTimeoutMillis = timeoutMillis;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.handshakeFuture = ctx.newPromise();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.fireExceptionCaught(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure((Throwable)new RuntimeException(String.format("WebSocket channel=[%s] closed before the handshake could complete. Server logs could contain the reason for abrupt connection disconnect or the server might not be reachable from the client anymore.", ctx.channel().id().asShortText())));
        }
        super.channelInactive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)event;
            if (e.state() == IdleState.READER_IDLE) {
                logger.warn("WebSocket connection {} has been idle for too long.", (Object)ctx.channel());
            } else if (e.state() == IdleState.WRITER_IDLE) {
                logger.debug("Sending ping frame to the server");
                ctx.writeAndFlush((Object)new PingWebSocketFrame());
            }
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(event)) {
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setSuccess();
            }
        } else if (WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(event)) {
            if (!this.handshakeFuture.isDone()) {
                this.handshakeFuture.setFailure((Throwable)new TimeoutException(String.format("handshake not completed in stipulated time=[%s]ms", this.connectionSetupTimeoutMillis)));
            }
        } else {
            super.userEventTriggered(ctx, event);
        }
    }
}

