/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.Instant;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class InstantSerializer
extends SimpleTypeSerializer<Instant> {
    public InstantSerializer() {
        super(DataType.INSTANT);
    }

    @Override
    protected Instant readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return Instant.ofEpochSecond(buffer.readLong(), buffer.readInt());
    }

    @Override
    protected void writeValue(Instant value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeLong(value.getEpochSecond()).writeInt(value.getNano());
    }
}

