/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.util.function.Lambda;

public class LambdaSerializer
extends SimpleTypeSerializer<Lambda> {
    public LambdaSerializer() {
        super(DataType.LAMBDA);
    }

    @Override
    Lambda readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        String lang = context.readValue(buffer, String.class, false);
        String script = context.readValue(buffer, String.class, false);
        int args = context.readValue(buffer, Integer.class, false);
        if (0 == args) {
            return new Lambda.ZeroArgLambda(script, lang);
        }
        if (1 == args) {
            return new Lambda.OneArgLambda(script, lang);
        }
        if (2 == args) {
            return new Lambda.TwoArgLambda(script, lang);
        }
        return new Lambda.UnknownArgLambda(script, lang, args);
    }

    @Override
    public ByteBuf writeValue(Lambda value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(3);
        result.addComponent(true, context.writeValue(value.getLambdaLanguage(), allocator, false));
        result.addComponent(true, context.writeValue(value.getLambdaScript(), allocator, false));
        result.addComponent(true, context.writeValue(value.getLambdaArguments(), allocator, false));
        return result;
    }
}

