/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Instant;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class InstantSerializer
extends SimpleTypeSerializer<Instant> {
    public InstantSerializer() {
        super(DataType.INSTANT);
    }

    @Override
    Instant readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return Instant.ofEpochSecond(buffer.readLong(), buffer.readInt());
    }

    @Override
    public ByteBuf writeValue(Instant value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return allocator.buffer(12).writeLong(value.getEpochSecond()).writeInt(value.getNano());
    }
}

