/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ByteBufferSerializer
extends SimpleTypeSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(DataType.BYTEBUFFER);
    }

    @Override
    ByteBuffer readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        ByteBuffer bb = ByteBuffer.allocate(buffer.readInt());
        buffer.readBytes(bb);
        return bb;
    }

    @Override
    public ByteBuf writeValue(ByteBuffer value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        byte[] bytes = value.array();
        return allocator.buffer(4 + bytes.length).writeInt(bytes.length).writeBytes(bytes);
    }
}

