/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;

public class BindingSerializer
extends SimpleTypeSerializer<Bytecode.Binding> {
    public BindingSerializer() {
        super(DataType.BINDING);
    }

    @Override
    Bytecode.Binding readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        String k = context.readValue(buffer, String.class, false);
        return new Bytecode.Binding(k, context.read(buffer));
    }

    @Override
    public ByteBuf writeValue(Bytecode.Binding value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.variable(), allocator, false));
        result.addComponent(true, context.write(value.value(), allocator));
        return result;
    }
}

