/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigInteger;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class BigIntegerSerializer
extends SimpleTypeSerializer<BigInteger> {
    public BigIntegerSerializer() {
        super(DataType.BIGINTEGER);
    }

    @Override
    BigInteger readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        byte[] bigIntBytes = new byte[buffer.readInt()];
        buffer.readBytes(bigIntBytes);
        return new BigInteger(bigIntBytes);
    }

    @Override
    public ByteBuf writeValue(BigInteger value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        byte[] twosComplement = value.toByteArray();
        return allocator.buffer(4 + twosComplement.length).writeInt(twosComplement.length).writeBytes(twosComplement);
    }
}

