/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class BigDecimalSerializer
extends SimpleTypeSerializer<BigDecimal> {
    public BigDecimalSerializer() {
        super(DataType.BIGDECIMAL);
    }

    @Override
    BigDecimal readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int scale = context.readValue(buffer, Integer.class, false);
        BigInteger unscaled = context.readValue(buffer, BigInteger.class, false);
        return new BigDecimal(unscaled, scale);
    }

    @Override
    public ByteBuf writeValue(BigDecimal value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.scale(), allocator, false));
        result.addComponent(true, context.writeValue(value.unscaledValue(), allocator, false));
        return result;
    }
}

