/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.process.remote.traversal.AbstractRemoteTraversalSideEffects;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSideEffects;

public class DriverRemoteTraversalSideEffects
extends AbstractRemoteTraversalSideEffects {
    private final Client client;
    private Set<String> keys = Collections.emptySet();
    private final UUID serverSideEffect;
    private final Host host;
    private final Map<String, Object> sideEffects = new HashMap<String, Object>();
    private boolean closed = false;
    private boolean retrievedAllKeys = false;
    private final CompletableFuture<Void> ready;

    public DriverRemoteTraversalSideEffects(Client client, UUID serverSideEffect, Host host, CompletableFuture<Void> ready) {
        this.client = client;
        this.serverSideEffect = serverSideEffect;
        this.host = host;
        this.ready = ready;
    }

    public <V> V get(String key) throws IllegalArgumentException {
        this.ready.join();
        if (!this.keys().contains(key)) {
            throw TraversalSideEffects.Exceptions.sideEffectKeyDoesNotExist((String)key);
        }
        if (!this.sideEffects.containsKey(key)) {
            if (this.closed) {
                throw new IllegalStateException("Traversal has been closed - no new side-effects can be retrieved");
            }
            RequestMessage msg = RequestMessage.build("gather").addArg("sideEffect", this.serverSideEffect).addArg("sideEffectKey", key).addArg("host", this.host).processor("traversal").create();
            try {
                Result result = this.client.submitAsync(msg).get().all().get().get(0);
                this.sideEffects.put(key, null == result ? null : result.getObject());
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not get side-effect for " + this.serverSideEffect + " with key of " + key, ex);
            }
        }
        return (V)this.sideEffects.get(key);
    }

    public Set<String> keys() {
        this.ready.join();
        if (this.closed && !this.retrievedAllKeys) {
            throw new IllegalStateException("Traversal has been closed - side-effect keys cannot be retrieved");
        }
        if (!this.retrievedAllKeys) {
            RequestMessage msg = RequestMessage.build("keys").addArg("sideEffect", this.serverSideEffect).addArg("host", this.host).processor("traversal").create();
            try {
                if (this.keys.equals(Collections.emptySet())) {
                    this.keys = new HashSet<String>();
                }
                this.client.submitAsync(msg).get().all().get().forEach(r -> this.keys.add(r.getString()));
                this.retrievedAllKeys = true;
            }
            catch (Exception ex) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                throw new RuntimeException("Could not get keys", null == root ? ex : root);
            }
        }
        return this.keys;
    }

    public void close() throws Exception {
        if (!this.closed) {
            RequestMessage msg = RequestMessage.build("close").addArg("sideEffect", this.serverSideEffect).addArg("host", this.host).processor("traversal").create();
            try {
                this.client.submitAsync(msg).get();
                this.closed = true;
            }
            catch (Exception ex) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                throw new RuntimeException("Error on closing side effects", null == root ? ex : root);
            }
        }
    }

    public String toString() {
        return "sideEffects[size:" + this.keys.size() + "]";
    }
}

