/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    private final InetSocketAddress address;
    private final URI hostUri;
    private volatile boolean isAvailable;
    private final Cluster cluster;
    private final String hostLabel;
    final AtomicReference<Boolean> retryInProgress = new AtomicReference<Boolean>(Boolean.FALSE);
    ScheduledFuture<?> retryThread = null;

    Host(InetSocketAddress address, Cluster cluster) {
        this.cluster = cluster;
        this.address = address;
        this.hostUri = Host.makeUriFromAddress(address, cluster.connectionPoolSettings().enableSsl);
        this.hostLabel = String.format("Host{address=%s, hostUri=%s}", address, this.hostUri);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public URI getHostUri() {
        return this.hostUri;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    void makeAvailable() {
        this.isAvailable = true;
    }

    void makeUnavailable(Function<Host, Boolean> reconnect) {
        this.isAvailable = false;
        if (this.retryInProgress.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            this.retryThread = this.cluster.executor().scheduleAtFixedRate(() -> {
                logger.debug("Trying to reconnect to dead host at {}", (Object)this);
                if (((Boolean)reconnect.apply(this)).booleanValue()) {
                    this.reconnected();
                }
            }, this.cluster.connectionPoolSettings().reconnectInitialDelay, this.cluster.connectionPoolSettings().reconnectInterval, TimeUnit.MILLISECONDS);
        }
    }

    private void reconnected() {
        this.retryThread.cancel(false);
        this.retryThread = null;
        this.retryInProgress.set(Boolean.FALSE);
        this.makeAvailable();
    }

    private static URI makeUriFromAddress(InetSocketAddress addy, boolean ssl) {
        try {
            String scheme = ssl ? "wss" : "ws";
            return new URI(scheme, null, addy.getHostName(), addy.getPort(), "/gremlin", null, null);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(String.format("URI for host could not be constructed from: %s", addy), use);
        }
    }

    public String toString() {
        return this.hostLabel;
    }

    public static interface Listener {
        public void onAvailable(Host var1);

        public void onUnavailable(Host var1);

        public void onNew(Host var1);

        public void onRemove(Host var1);
    }
}

