/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.ListAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttributeContext
implements AttributeContext,
Serializable {
    protected String template = null;
    protected Set<String> roles = null;
    protected String preparer = null;
    protected Map<String, Attribute> attributes = null;
    protected Map<String, Attribute> cascadedAttributes = null;

    public BasicAttributeContext() {
    }

    public BasicAttributeContext(Map<String, Attribute> attributes) {
        if (attributes != null) {
            this.attributes = new HashMap<String, Attribute>(attributes);
        }
    }

    public BasicAttributeContext(AttributeContext context) {
        if (context instanceof BasicAttributeContext) {
            this.copyBasicAttributeContext((BasicAttributeContext)context);
        } else {
            this.template = context.getTemplate();
            Set<String> roles = context.getRoles();
            if (roles != null && !roles.isEmpty()) {
                this.roles = new HashSet<String>(roles);
            }
            this.preparer = context.getPreparer();
            this.attributes = new HashMap<String, Attribute>();
            for (String name : context.getLocalAttributeNames()) {
                this.attributes.put(name, context.getLocalAttribute(name));
            }
            this.inheritCascadedAttributes(context);
        }
    }

    public BasicAttributeContext(BasicAttributeContext context) {
        this.copyBasicAttributeContext(context);
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public String getRole() {
        String retValue = null;
        if (this.roles != null && !this.roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> roleIt = this.roles.iterator();
            if (roleIt.hasNext()) {
                builder.append(roleIt.next());
                while (roleIt.hasNext()) {
                    builder.append(",");
                    builder.append(roleIt.next());
                }
                retValue = builder.toString();
            }
        }
        return retValue;
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRole(String role) {
        if (role != null && role.trim().length() > 0) {
            String[] rolesStrings = role.split("\\s*,\\s*");
            this.roles = new HashSet<String>();
            for (int i = 0; i < rolesStrings.length; ++i) {
                this.roles.add(rolesStrings[i]);
            }
        } else {
            this.roles = null;
        }
    }

    @Override
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @Override
    public String getPreparer() {
        return this.preparer;
    }

    @Override
    public void setPreparer(String url) {
        this.preparer = url;
    }

    @Override
    public void inheritCascadedAttributes(AttributeContext context) {
        if (context instanceof BasicAttributeContext) {
            this.copyCascadedAttributes((BasicAttributeContext)context);
        } else {
            this.cascadedAttributes = new HashMap<String, Attribute>();
            for (String name : context.getCascadedAttributeNames()) {
                this.cascadedAttributes.put(name, context.getCascadedAttribute(name));
            }
        }
    }

    @Override
    public void inherit(AttributeContext parent) {
        if (parent instanceof BasicAttributeContext) {
            this.inherit((BasicAttributeContext)parent);
        } else {
            Attribute destAttribute;
            Attribute attribute;
            Set<String> names;
            if (this.template == null) {
                this.template = parent.getTemplate();
            }
            Set<String> parentRoles = parent.getRoles();
            if ((this.roles == null || this.roles.isEmpty()) && parentRoles != null && !parentRoles.isEmpty()) {
                this.roles = new HashSet<String>(parentRoles);
            }
            if (this.preparer == null) {
                this.preparer = parent.getPreparer();
            }
            if ((names = parent.getCascadedAttributeNames()) != null && !names.isEmpty()) {
                for (String name : names) {
                    attribute = parent.getCascadedAttribute(name);
                    destAttribute = this.getCascadedAttribute(name);
                    if (destAttribute == null) {
                        this.putAttribute(name, attribute, true);
                        continue;
                    }
                    if (!(attribute instanceof ListAttribute) || !(destAttribute instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                    ((ListAttribute)destAttribute).inherit((ListAttribute)attribute);
                }
            }
            if ((names = parent.getLocalAttributeNames()) != null && !names.isEmpty()) {
                for (String name : names) {
                    attribute = parent.getLocalAttribute(name);
                    destAttribute = this.getLocalAttribute(name);
                    if (destAttribute == null) {
                        this.putAttribute(name, attribute, false);
                        continue;
                    }
                    if (!(attribute instanceof ListAttribute) || !(destAttribute instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                    ((ListAttribute)destAttribute).inherit((ListAttribute)attribute);
                }
            }
        }
    }

    public void inherit(BasicAttributeContext parent) {
        if (this.template == null) {
            this.template = parent.template;
        }
        if ((this.roles == null || this.roles.isEmpty()) && parent.roles != null && !parent.roles.isEmpty()) {
            this.roles = new HashSet<String>(parent.roles);
        }
        if (this.preparer == null) {
            this.preparer = parent.preparer;
        }
        this.cascadedAttributes = this.addMissingAttributes(parent.cascadedAttributes, this.cascadedAttributes);
        this.attributes = this.addMissingAttributes(parent.attributes, this.attributes);
    }

    @Override
    public void addAll(Map<String, Attribute> newAttributes) {
        if (newAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(newAttributes);
            return;
        }
        this.attributes.putAll(newAttributes);
    }

    @Override
    public void addMissing(Map<String, Attribute> defaultAttributes) {
        if (defaultAttributes == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>(defaultAttributes);
            if (this.cascadedAttributes == null || this.cascadedAttributes.isEmpty()) {
                return;
            }
        }
        Set<Map.Entry<String, Attribute>> entries = defaultAttributes.entrySet();
        for (Map.Entry<String, Attribute> entry : entries) {
            String key = entry.getKey();
            if (this.attributes.containsKey(key) || this.cascadedAttributes != null && !this.cascadedAttributes.containsKey(key)) continue;
            this.attributes.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute retValue = null;
        if (this.attributes != null) {
            retValue = this.attributes.get(name);
        }
        if (retValue == null && this.cascadedAttributes != null) {
            retValue = this.cascadedAttributes.get(name);
        }
        return retValue;
    }

    @Override
    public Attribute getLocalAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Attribute getCascadedAttribute(String name) {
        if (this.cascadedAttributes == null) {
            return null;
        }
        return this.cascadedAttributes.get(name);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        HashSet<String> attributeSet = null;
        if (this.attributes != null && !this.attributes.isEmpty()) {
            attributeSet = new HashSet<String>(this.attributes.keySet());
            if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
                attributeSet.addAll(this.cascadedAttributes.keySet());
            }
        } else if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
            attributeSet = new HashSet<String>(this.cascadedAttributes.keySet());
        }
        if (attributeSet != null) {
            return attributeSet.iterator();
        }
        return new ArrayList().iterator();
    }

    @Override
    public Set<String> getLocalAttributeNames() {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            return this.attributes.keySet();
        }
        return null;
    }

    @Override
    public Set<String> getCascadedAttributeNames() {
        if (this.cascadedAttributes != null && !this.cascadedAttributes.isEmpty()) {
            return this.cascadedAttributes.keySet();
        }
        return null;
    }

    @Override
    public void putAttribute(String name, Attribute value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Attribute>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public void putAttribute(String name, Attribute value, boolean cascade) {
        Map<String, Attribute> mapToUse;
        if (cascade) {
            if (this.cascadedAttributes == null) {
                this.cascadedAttributes = new HashMap<String, Attribute>();
            }
            mapToUse = this.cascadedAttributes;
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Attribute>();
            }
            mapToUse = this.attributes;
        }
        mapToUse.put(name, value);
    }

    @Override
    public void clear() {
        this.template = null;
        this.preparer = null;
        this.roles = null;
        this.attributes.clear();
        this.cascadedAttributes.clear();
    }

    private void copyBasicAttributeContext(BasicAttributeContext context) {
        this.template = context.template;
        Set<String> roles = context.roles;
        if (roles != null && !roles.isEmpty()) {
            this.roles = new HashSet<String>(roles);
        }
        this.preparer = context.preparer;
        if (context.attributes != null && !context.attributes.isEmpty()) {
            this.attributes = new HashMap<String, Attribute>(context.attributes);
        }
        this.copyCascadedAttributes(context);
    }

    private void copyCascadedAttributes(BasicAttributeContext context) {
        if (context.cascadedAttributes != null && !context.cascadedAttributes.isEmpty()) {
            this.cascadedAttributes = new HashMap<String, Attribute>(context.cascadedAttributes);
        }
    }

    private Map<String, Attribute> addMissingAttributes(Map<String, Attribute> source, Map<String, Attribute> destination) {
        if (source != null && !source.isEmpty()) {
            if (destination == null) {
                destination = new HashMap<String, Attribute>();
            }
            for (Map.Entry<String, Attribute> entry : source.entrySet()) {
                String key = entry.getKey();
                Attribute destAttribute = destination.get(key);
                if (destAttribute == null) {
                    destination.put(key, entry.getValue());
                    continue;
                }
                if (!(destAttribute instanceof ListAttribute) || !(entry.getValue() instanceof ListAttribute) || !((ListAttribute)destAttribute).isInherit()) continue;
                ((ListAttribute)destAttribute).inherit((ListAttribute)entry.getValue());
            }
        }
        return destination;
    }
}

