/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.IOException;
import java.io.Writer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadata;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.EmitKey;

public class JsonEmitData {
    public static void toJson(EmitData emitData, Writer writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createGenerator(writer);){
            jsonGenerator.writeStartObject();
            EmitKey key = emitData.getEmitKey();
            jsonGenerator.writeStringField("emitter", key.getEmitterName());
            jsonGenerator.writeStringField("emitKey", key.getEmitKey());
            jsonGenerator.writeFieldName("data");
            jsonGenerator.writeStartArray();
            for (Metadata m : emitData.getMetadataList()) {
                JsonMetadata.writeMetadataObject(m, jsonGenerator, false);
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }
    }
}

