/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PDFMarkedContent2XHTMLTest
extends TikaTest {
    static ParseContext MARKUP_CONTEXT = new ParseContext();

    @BeforeAll
    public static void setUp() {
        PDFParserConfig config = new PDFParserConfig();
        config.setExtractMarkedContent(true);
        MARKUP_CONTEXT.set(PDFParserConfig.class, (Object)config);
    }

    @Test
    public void testJournal() throws Exception {
        String xml = this.getXML((String)"testJournalParser.pdf", (ParseContext)PDFMarkedContent2XHTMLTest.MARKUP_CONTEXT).xml;
        PDFMarkedContent2XHTMLTest.assertContains((String)"<h1>I. INTRODUCTION</h1>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<table><tr>\t<td><p />", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"</td>\t<td><p>NHG</p>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"</td>\t<td><p>STRING</p>", (String)xml);
    }

    @Test
    public void testVarious() throws Exception {
        String xml = this.getXML((String)"testPDFVarious.pdf", (ParseContext)PDFMarkedContent2XHTMLTest.MARKUP_CONTEXT).xml;
        PDFMarkedContent2XHTMLTest.assertContains((String)"<div class=\"textbox\"><p>Here is a text box</p>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<div class=\"footnote\"><p>1 This is a footnote.</p>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<ul>\t<li>Bullet 1</li>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<table><tr>\t<td><p>Row 1 Col 1</p>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<p>Here is a citation:</p>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"a href=\"http://tika.apache.org/\">This is a hyperlink</a>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"This is the header text.", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"This is the footer text.", (String)xml);
    }

    @Test
    public void testChildAttachments() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDF_childAttachments.pdf", MARKUP_CONTEXT);
        Assertions.assertEquals((int)3, (int)metadataList.size());
        String xml = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<a href=\"http://www.irs.gov\">IRS.gov</a>", (String)xml);
        PDFMarkedContent2XHTMLTest.assertContains((String)"<a href=\"http://www.irs.gov/pub15\">www.irs.gov/pub15</a>", (String)xml);
    }
}

