/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;

@Provider
@Consumes(value={"text/xml", "application/xml", "application/*+xml"})
public class XPathProvider<T>
implements MessageBodyReader<T> {
    private List<String> consumeMediaTypes;
    private Map<String, String> classExpressions;
    private String globalExpression;
    private String className;
    private boolean forceDOM;
    private Map<String, String> globalNamespaces = Collections.emptyMap();

    public void setConsumeMediaTypes(List<String> types) {
        this.consumeMediaTypes = types;
    }

    public List<String> getConsumeMediaTypes() {
        return this.consumeMediaTypes;
    }

    public void setForceDOM(boolean b) {
        this.forceDOM = b;
    }

    public void setExpression(String expr) {
        this.globalExpression = expr;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setExpressions(Map<String, String> expressions) {
        this.classExpressions = expressions;
    }

    public void setNamespaces(Map<String, String> nsMap) {
        this.globalNamespaces = nsMap;
    }

    @Override
    public boolean isReadable(Class<?> cls, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.globalExpression != null && (this.className == null || this.className.equals(cls.getName())) || this.classExpressions != null && this.classExpressions.containsKey(cls.getName());
    }

    @Override
    public T readFrom(Class<T> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> hrs, InputStream is) throws IOException, WebApplicationException {
        String expression;
        String string = expression = this.globalExpression != null ? this.globalExpression : this.classExpressions.get(cls.getName());
        if (expression == null) {
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        XMLSource source = new XMLSource(is);
        if (this.forceDOM) {
            source.setBuffering();
        }
        return source.getNode(expression, this.globalNamespaces, cls);
    }
}

