/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class WriterInterceptorMBW
implements WriterInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WriterInterceptorMBW.class);
    private MessageBodyWriter<Object> writer;
    private Message m;

    public WriterInterceptorMBW(MessageBodyWriter<Object> writer, Message m) {
        this.writer = writer;
        this.m = m;
    }

    public MessageBodyWriter<Object> getMBW() {
        return this.writer;
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext c) throws IOException, WebApplicationException {
        MultivaluedMap<String, Object> headers = c.getHeaders();
        Object mtObject = headers.getFirst("Content-Type");
        MediaType entityMt = mtObject == null ? c.getMediaType() : JAXRSUtils.toMediaType(mtObject.toString());
        this.m.put("Content-Type", entityMt.toString());
        Class<?> entityCls = c.getType();
        Type entityType = c.getGenericType();
        Annotation[] entityAnns = c.getAnnotations();
        if (this.writer == null || this.m.get("provider.selection.property.changed") == Boolean.TRUE && !this.writer.isWriteable(entityCls, entityType, entityAnns, entityMt)) {
            this.writer = ProviderFactory.getInstance(this.m).createMessageBodyWriter(entityCls, entityType, entityAnns, entityMt, this.m);
        }
        if (this.writer == null) {
            String errorMessage = JAXRSUtils.logMessageHandlerProblem("NO_MSG_WRITER", entityCls, entityMt);
            throw new ProcessingException(errorMessage);
        }
        HttpUtils.convertHeaderValuesToString(headers, true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Response EntityProvider is: " + this.writer.getClass().getName());
        }
        this.writer.writeTo(c.getEntity(), c.getType(), c.getGenericType(), c.getAnnotations(), entityMt, headers, c.getOutputStream());
    }
}

