/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.recognition.tf;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.tika.config.Field;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.recognition.tf.TensorflowRESTRecogniser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TensorflowRESTVideoRecogniser
extends TensorflowRESTRecogniser {
    private static final Logger LOG = LoggerFactory.getLogger(TensorflowRESTVideoRecogniser.class);
    private static final Set<MediaType> SUPPORTED_MIMES = Collections.singleton(MediaType.video((String)"mp4"));
    @Field
    private String mode = "fixed";

    @Override
    protected URI getApiUri(Metadata metadata) {
        TikaConfig config = TikaConfig.getDefaultConfig();
        String ext = null;
        try {
            MimeType mimeType = config.getMimeRepository().forName(metadata.get("Content-Type"));
            ext = mimeType.getExtension();
            return UriBuilder.fromUri((URI)this.apiUri).queryParam("ext", new Object[]{ext}).build(new Object[0]);
        }
        catch (MimeTypeException e) {
            LOG.error("Can't find extension from metadata");
            return this.apiUri;
        }
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.healthUri = URI.create(this.apiBaseUri + "/ping");
        this.apiUri = URI.create(this.apiBaseUri + String.format(Locale.getDefault(), "/classify/video?topn=%1$d&min_confidence=%2$f&mode=%3$s", this.topN, this.minConfidence, this.mode));
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.healthUri));
            this.available = response.getStatusLine().getStatusCode() == 200;
            LOG.info("Available = {}, API Status = {}", (Object)this.available, (Object)response.getStatusLine());
            LOG.info("topN = {}, minConfidence = {}", (Object)this.topN, (Object)this.minConfidence);
        }
        catch (Exception e) {
            this.available = false;
            throw new TikaConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

