/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.xml.namespace.QName;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.example.Pharmacy;
import org.apache.tika.io.LookaheadInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class EncryptedPrescriptionDetector
implements Detector {
    private static final long serialVersionUID = -1709652690773421147L;

    public MediaType detect(InputStream stream, Metadata metadata) throws IOException {
        Key key = Pharmacy.getKey();
        MediaType type = MediaType.OCTET_STREAM;
        try (LookaheadInputStream lookahead = new LookaheadInputStream(stream, 1024);){
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            CipherInputStream decrypted = new CipherInputStream((InputStream)lookahead, cipher);
            QName name = new XmlRootExtractor().extractRootElement((InputStream)decrypted);
            if (name != null && "http://example.com/xpd".equals(name.getNamespaceURI()) && "prescription".equals(name.getLocalPart())) {
                type = MediaType.application((String)"x-prescription");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return type;
    }
}

