/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.detect.NonDetectingEncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.multiple.AbstractMultipleParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PickBestTextEncodingParser
extends AbstractMultipleParser {
    private static final long serialVersionUID = 730345169223211807L;
    private String[] charsetsToTry;

    public PickBestTextEncodingParser(MediaTypeRegistry registry, String[] charsets) {
        super(registry, AbstractMultipleParser.MetadataPolicy.DISCARD_ALL, PickBestTextEncodingParser.makeParsers(charsets));
        this.charsetsToTry = charsets;
    }

    private static List<Parser> makeParsers(String[] charsets) {
        ArrayList<Parser> parsers = new ArrayList<Parser>(charsets.length + 1);
        for (int i = 0; i < charsets.length + 1; ++i) {
            parsers.set(i, (Parser)new TXTParser());
        }
        return parsers;
    }

    protected void parserPrepare(Parser parser, Metadata metadata, ParseContext context) {
        super.parserPrepare(parser, metadata, context);
        String charset = ((CharsetTester)context.get(CharsetTester.class)).getNextCharset();
        Charset charsetCS = Charset.forName(charset);
        context.set(EncodingDetector.class, (Object)new NonDetectingEncodingDetector(charsetCS));
    }

    protected boolean parserCompleted(Parser parser, Metadata metadata, ContentHandler handler, ParseContext context, Exception exception) {
        CharsetTester charsetTester = (CharsetTester)context.get(CharsetTester.class);
        String charset = charsetTester.getCurrentCharset();
        if (charsetTester.stillTesting()) {
            charsetTester.charsetText.put(charset, handler.toString());
            if (!charsetTester.moreToTest()) {
                int numEnglish = 0;
                String bestcharset = null;
                for (String pcharset : charsetTester.charsetText.keySet()) {
                    String text = charsetTester.charsetText.get(pcharset);
                    int cEnglish = 0;
                    for (char c : text.toCharArray()) {
                        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) continue;
                        ++cEnglish;
                    }
                    if (cEnglish <= numEnglish) continue;
                    numEnglish = cEnglish;
                    bestcharset = pcharset;
                }
                charsetTester.pickedCharset = bestcharset;
            }
        }
        return true;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata originalMetadata, ParseContext context) throws IOException, SAXException, TikaException {
        CharsetContentHandlerFactory handlerFactory = new CharsetContentHandlerFactory();
        handlerFactory.handler = handler;
        context.set(CharsetTester.class, (Object)new CharsetTester());
        super.parse(stream, (ContentHandlerFactory)handlerFactory, originalMetadata, context);
    }

    public void parse(InputStream stream, ContentHandlerFactory handlers, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.parse(stream, handlers.getNewContentHandler(), metadata, context);
    }

    protected class CharsetTester {
        private int index = -1;
        private String pickedCharset;
        private Map<String, String> charsetText = new HashMap<String, String>();

        protected CharsetTester() {
        }

        protected String getNextCharset() {
            ++this.index;
            return this.getCurrentCharset();
        }

        protected String getCurrentCharset() {
            if (this.index < PickBestTextEncodingParser.this.charsetsToTry.length) {
                return PickBestTextEncodingParser.this.charsetsToTry[this.index];
            }
            return this.pickedCharset;
        }

        protected boolean stillTesting() {
            return this.index < PickBestTextEncodingParser.this.charsetsToTry.length;
        }

        protected boolean moreToTest() {
            return this.index < PickBestTextEncodingParser.this.charsetsToTry.length - 1;
        }
    }

    protected class CharsetContentHandlerFactory
    implements ContentHandlerFactory {
        private int index = -1;
        private ContentHandler handler;

        protected CharsetContentHandlerFactory() {
        }

        public ContentHandler getNewContentHandler() {
            ++this.index;
            if (this.index < PickBestTextEncodingParser.this.charsetsToTry.length) {
                return new BodyContentHandler();
            }
            return this.handler;
        }

        public ContentHandler getNewContentHandler(OutputStream os, Charset charset) {
            return this.getNewContentHandler();
        }
    }
}

