/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.example;

import java.io.InputStream;
import org.apache.tika.Tika;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;

public class AdvancedTypeDetector {
    public static String detectWithCustomConfig(String name) throws Exception {
        String config = "/org/apache/tika/mime/tika-mimetypes.xml";
        Tika tika = new Tika((Detector)MimeTypesFactory.create((String)config));
        return tika.detect(name);
    }

    public static String detectWithCustomDetector(String name) throws Exception {
        String config = "/org/apache/tika/mime/tika-mimetypes.xml";
        MimeTypes detector = MimeTypesFactory.create((String)config);
        Detector custom = new Detector(){
            private static final long serialVersionUID = -5420638839201540749L;

            public MediaType detect(InputStream input, Metadata metadata) {
                String type = metadata.get("my-custom-type-override");
                if (type != null) {
                    return MediaType.parse((String)type);
                }
                return MediaType.OCTET_STREAM;
            }
        };
        Tika tika = new Tika((Detector)new CompositeDetector(new Detector[]{custom, detector}));
        return tika.detect(name);
    }
}

