/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.api.TezRuntimeConfiguration;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.PipelinedSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class OrderedPartitionedKVOutput
extends AbstractLogicalOutput {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPartitionedKVOutput.class);
    protected ExternalSorter sorter;
    protected Configuration conf;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private long startTime;
    private long endTime;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    @VisibleForTesting
    boolean pipelinedShuffle;
    private boolean sendEmptyPartitionDetails;
    @VisibleForTesting
    boolean finalMergeEnabled;
    private static final Set<String> confKeys = new HashSet<String>();

    public OrderedPartitionedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public synchronized List<Event> initialize() throws IOException {
        this.startTime = System.nanoTime();
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.getContext().requestInitialMemory(ExternalSorter.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.sendEmptyPartitionDetails = this.conf.getBoolean("tez.runtime.empty.partitions.info-via-events.enabled", true);
        return Collections.emptyList();
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            String sorterClass = this.conf.get("tez.runtime.sorter.class", TezRuntimeConfiguration.TEZ_RUNTIME_SORTER_CLASS_DEFAULT).toUpperCase(Locale.ENGLISH);
            OrderedPartitionedKVOutputConfig.SorterImpl sorterImpl = null;
            try {
                sorterImpl = OrderedPartitionedKVOutputConfig.SorterImpl.valueOf(sorterClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid sorter class specified in config, propertyName=tez.runtime.sorter.class, value=" + sorterClass + ", validValues=" + Arrays.asList(OrderedPartitionedKVOutputConfig.SorterImpl.values()));
            }
            this.finalMergeEnabled = this.conf.getBoolean("tez.runtime.enable.final-merge.in.output", true);
            this.pipelinedShuffle = this.conf.getBoolean("tez.runtime.pipelined-shuffle.enabled", false);
            if (this.pipelinedShuffle) {
                if (this.finalMergeEnabled) {
                    LOG.info(this.getContext().getDestinationVertexName() + " disabling final merge as " + "tez.runtime.pipelined-shuffle.enabled" + " is enabled.");
                    this.finalMergeEnabled = false;
                    this.conf.setBoolean("tez.runtime.enable.final-merge.in.output", false);
                }
                Preconditions.checkArgument((boolean)sorterImpl.equals((Object)OrderedPartitionedKVOutputConfig.SorterImpl.PIPELINED), (Object)"tez.runtime.pipelined-shuffle.enabledonly works with PipelinedSorter.");
            }
            if (sorterImpl.equals((Object)OrderedPartitionedKVOutputConfig.SorterImpl.PIPELINED)) {
                this.sorter = new PipelinedSorter(this.getContext(), this.conf, this.getNumPhysicalOutputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            } else if (sorterImpl.equals((Object)OrderedPartitionedKVOutputConfig.SorterImpl.LEGACY)) {
                this.sorter = new DefaultSorter(this.getContext(), this.conf, this.getNumPhysicalOutputs(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            } else {
                throw new UnsupportedOperationException("Unsupported sorter class specified in config, propertyName=tez.runtime.sorter.class, value=" + sorterClass + ", validValues=" + Arrays.asList(OrderedPartitionedKVOutputConfig.SorterImpl.values()));
            }
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValuesWriter getWriter() throws IOException {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Cannot get writer before starting the Output");
        return new KeyValuesWriter(){

            @Override
            public void write(Object key, Object value) throws IOException {
                OrderedPartitionedKVOutput.this.sorter.write(key, value);
            }

            @Override
            public void write(Object key, Iterable<Object> values) throws IOException {
                OrderedPartitionedKVOutput.this.sorter.write(key, values);
            }
        };
    }

    public synchronized void handleEvents(List<Event> outputEvents) {
    }

    public synchronized List<Event> close() throws IOException {
        List<Event> returnEvents = null;
        if (this.sorter != null) {
            this.sorter.flush();
            this.sorter.close();
            this.endTime = System.nanoTime();
            returnEvents = this.generateEvents();
        } else {
            LOG.warn(this.getContext().getDestinationVertexName() + ": Attempting to close output {} of type {} before it was started. Generating empty events", (Object)this.getContext().getDestinationVertexName(), (Object)((Object)((Object)this)).getClass().getSimpleName());
            returnEvents = this.generateEmptyEvents();
        }
        return returnEvents;
    }

    private List<Event> generateEvents() throws IOException {
        LinkedList eventList = Lists.newLinkedList();
        if (this.finalMergeEnabled && !this.pipelinedShuffle) {
            boolean isLastEvent = true;
            ShuffleUtils.generateEventOnSpill(eventList, this.finalMergeEnabled, isLastEvent, this.getContext(), 0, new TezSpillRecord(this.sorter.getFinalIndexFile(), this.conf), this.getNumPhysicalOutputs(), this.sendEmptyPartitionDetails, this.getContext().getUniqueIdentifier(), this.sorter.getPartitionStats());
        }
        return eventList;
    }

    private List<Event> generateEmptyEvents() throws IOException {
        LinkedList eventList = Lists.newLinkedList();
        ShuffleUtils.generateEventsForNonStartedOutput(eventList, this.getNumPhysicalOutputs(), this.getContext(), true, true);
        return eventList;
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.io.sort.factor");
        confKeys.add("tez.runtime.sort.spill.percent");
        confKeys.add("tez.runtime.io.sort.mb");
        confKeys.add("tez.runtime.report.partition.stats");
        confKeys.add("tez.runtime.index.cache.memory.limit.bytes");
        confKeys.add("tez.runtime.combine.min.spills");
        confKeys.add("tez.runtime.pipelined.sorter.sort.threads");
        confKeys.add("tez.runtime.pipelined.sorter.min-block.size.in.mb");
        confKeys.add("tez.runtime.pipelined.sorter.lazy-allocate.memory");
        confKeys.add("tez.runtime.partitioner.class");
        confKeys.add("tez.runtime.combiner.class");
        confKeys.add("tez.runtime.internal.sorter.class");
        confKeys.add("tez.runtime.key.comparator.class");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.runtime.pipelined-shuffle.enabled");
        confKeys.add("tez.runtime.enable.final-merge.in.output");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.sorter.class");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
    }
}

