/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalOutput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.api.Partitioner;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.writers.UnorderedPartitionedKVWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class UnorderedKVOutput
extends AbstractLogicalOutput {
    private static final Logger LOG = LoggerFactory.getLogger(UnorderedKVOutput.class);
    @VisibleForTesting
    UnorderedPartitionedKVWriter kvWriter;
    private Configuration conf;
    private MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private static final Set<String> confKeys = new HashSet<String>();

    public UnorderedKVOutput(OutputContext outputContext, int numPhysicalOutputs) {
        super(outputContext, numPhysicalOutputs);
    }

    public synchronized List<Event> initialize() throws Exception {
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.conf.setStrings("tez.runtime.framework.local.dirs", this.getContext().getWorkDirs());
        this.conf.set("tez.runtime.partitioner.class", CustomPartitioner.class.getName());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        boolean pipelinedShuffle = this.conf.getBoolean("tez.runtime.pipelined-shuffle.enabled", false);
        long memRequestSize = pipelinedShuffle ? UnorderedPartitionedKVWriter.getInitialMemoryRequirement(this.conf, this.getContext().getTotalMemoryAvailableToTask()) : 0L;
        this.getContext().requestInitialMemory(memRequestSize, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        return Collections.emptyList();
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.kvWriter = new UnorderedPartitionedKVWriter(this.getContext(), this.conf, 1, this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.isStarted.set(true);
            LOG.info(((Object)((Object)this)).getClass().getSimpleName() + " started. MemoryAssigned=" + this.memoryUpdateCallbackHandler.getMemoryAssigned());
        }
    }

    public synchronized KeyValuesWriter getWriter() throws Exception {
        return this.kvWriter;
    }

    public synchronized void handleEvents(List<Event> outputEvents) {
        throw new TezUncheckedException("Not expecting any events");
    }

    public synchronized List<Event> close() throws Exception {
        List<Event> returnEvents = null;
        if (this.isStarted.get()) {
            returnEvents = this.kvWriter.close();
        } else {
            LOG.warn("Attempting to close output {} of type {} before it was started. Generating empty events", (Object)this.getContext().getDestinationVertexName(), (Object)((Object)((Object)this)).getClass().getSimpleName());
            returnEvents = new LinkedList<Event>();
            ShuffleUtils.generateEventsForNonStartedOutput(returnEvents, this.getNumPhysicalOutputs(), this.getContext(), false, false);
        }
        long outputSize = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES).getValue();
        this.getContext().getStatisticsReporter().reportDataSize(outputSize);
        long outputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(outputRecords);
        return returnEvents;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    String getHost() {
        return this.getContext().getExecutionContext().getHostName();
    }

    @InterfaceAudience.Private
    public static Set<String> getConfigurationKeySet() {
        return Collections.unmodifiableSet(confKeys);
    }

    static {
        confKeys.add("tez.runtime.ifile.readahead");
        confKeys.add("tez.runtime.ifile.readahead.bytes");
        confKeys.add("io.file.buffer.size");
        confKeys.add("tez.runtime.unordered.output.buffer.size-mb");
        confKeys.add("tez.runtime.unordered.output.max-per-buffer.size-bytes");
        confKeys.add("tez.runtime.key.class");
        confKeys.add("tez.runtime.value.class");
        confKeys.add("tez.runtime.compress");
        confKeys.add("tez.runtime.compress.codec");
        confKeys.add("tez.runtime.empty.partitions.info-via-events.enabled");
        confKeys.add("tez.runtime.convert.user-payload.to.history-text");
        confKeys.add("tez.runtime.pipelined-shuffle.enabled");
        confKeys.add("tez.counters.max");
        confKeys.add("tez.counters.group-name.max-length");
        confKeys.add("tez.counters.counter-name.max-length");
        confKeys.add("tez.counters.max.groups");
        confKeys.add("tez.runtime.cleanup.files.on.interrupt");
    }

    @InterfaceAudience.Private
    public static class CustomPartitioner
    implements Partitioner {
        @Override
        public int getPartition(Object key, Object value, int numPartitions) {
            return 0;
        }
    }
}

