/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MergeThread<T>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(MergeThread.class);
    private volatile boolean inProgress = false;
    private final List<T> inputs = new ArrayList<T>();
    protected final MergeManager manager;
    private final ExceptionReporter reporter;
    private boolean closed = false;
    private final int mergeFactor;

    public MergeThread(MergeManager manager, int mergeFactor, ExceptionReporter reporter) {
        this.manager = manager;
        this.mergeFactor = mergeFactor;
        this.reporter = reporter;
    }

    public synchronized void close() throws InterruptedException {
        this.closed = true;
        if (!Thread.currentThread().isInterrupted()) {
            this.waitForMerge();
            this.interrupt();
        } else {
            try {
                this.interrupt();
                this.cleanup(this.inputs, Thread.currentThread().isInterrupted());
            }
            catch (IOException e) {
                LOG.warn("Error cleaning up", (Throwable)e);
            }
        }
    }

    public synchronized boolean isInProgress() {
        return this.inProgress;
    }

    public synchronized void startMerge(Set<T> inputs) {
        if (!this.closed) {
            this.inputs.clear();
            this.inProgress = true;
            Iterator<T> iter = inputs.iterator();
            for (int ctr = 0; iter.hasNext() && ctr < this.mergeFactor; ++ctr) {
                this.inputs.add(iter.next());
                iter.remove();
            }
            LOG.info(this.getName() + ": Starting merge with " + this.inputs.size() + " segments, while ignoring " + inputs.size() + " segments");
            this.notifyAll();
        }
    }

    public synchronized void waitForMerge() throws InterruptedException {
        while (this.inProgress) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                MergeThread mergeThread = this;
                synchronized (mergeThread) {
                    while (!this.inProgress) {
                        this.wait();
                    }
                }
                this.merge(this.inputs);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                this.reporter.reportException(t);
                return;
            }
            finally {
                MergeThread mergeThread = this;
                synchronized (mergeThread) {
                    this.inputs.clear();
                    this.inProgress = false;
                    this.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    public abstract void merge(List<T> var1) throws IOException, InterruptedException;

    public abstract void cleanup(List<T> var1, boolean var2) throws IOException, InterruptedException;
}

