/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInput;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;

public class MemoryFetchedInput
extends FetchedInput {
    private BoundedByteArrayOutputStream byteStream;

    public MemoryFetchedInput(long actualSize, long compressedSize, InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler) {
        super(FetchedInput.Type.MEMORY, actualSize, compressedSize, inputAttemptIdentifier, callbackHandler);
        this.byteStream = new BoundedByteArrayOutputStream((int)actualSize);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.byteStream;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteStream.getBuffer());
    }

    public byte[] getBytes() {
        return this.byteStream.getBuffer();
    }

    @Override
    public void commit() {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.COMMITTED;
            this.notifyFetchComplete();
        }
    }

    @Override
    public void abort() {
        if (this.state == FetchedInput.State.PENDING) {
            this.state = FetchedInput.State.ABORTED;
            this.notifyFetchFailure();
        }
    }

    @Override
    public void free() {
        Preconditions.checkState((this.state == FetchedInput.State.COMMITTED || this.state == FetchedInput.State.ABORTED ? 1 : 0) != 0, (Object)"FetchedInput can only be freed after it is committed or aborted");
        if (this.state == FetchedInput.State.COMMITTED) {
            this.state = FetchedInput.State.FREED;
            this.byteStream = null;
            this.notifyFreedResource();
        }
    }

    public String toString() {
        return "MemoryFetchedInput [inputAttemptIdentifier=" + this.inputAttemptIdentifier + ", actualSize=" + this.actualSize + ", compressedSize=" + this.compressedSize + ", type=" + (Object)((Object)this.type) + ", id=" + this.id + ", state=" + (Object)((Object)this.state) + "]";
    }
}

