/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.broadcast.output;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.library.api.KeyValuesWriter;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;

@InterfaceAudience.Private
public class FileBasedKVWriter
extends KeyValuesWriter {
    private static final Log LOG = LogFactory.getLog(FileBasedKVWriter.class);
    public static final int INDEX_RECORD_LENGTH = 24;
    private final Configuration conf;
    private int numRecords = 0;
    private final Class keyClass;
    private final Class valClass;
    private final CompressionCodec codec;
    private final FileSystem rfs;
    private final IFile.Writer writer;
    private final Path outputPath;
    private Path indexPath;
    private final TezTaskOutput ouputFileManager;
    private boolean closed = false;
    private final TezCounter outputRecordsCounter;
    private final TezCounter outputBytesCounter;
    private final TezCounter outputBytesCounterWithOverhead;
    private final TezCounter outputMaterializedBytesCounter;

    public FileBasedKVWriter(OutputContext outputContext, Configuration conf) throws IOException {
        this.conf = conf;
        this.outputRecordsCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_RECORDS);
        this.outputBytesCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES);
        this.outputBytesCounterWithOverhead = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_WITH_OVERHEAD);
        this.outputMaterializedBytesCounter = outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES_PHYSICAL);
        this.rfs = FileSystem.getLocal((Configuration)this.conf).getRaw();
        this.keyClass = ConfigUtils.getIntermediateOutputKeyClass(this.conf);
        this.valClass = ConfigUtils.getIntermediateOutputValueClass(this.conf);
        if (ConfigUtils.shouldCompressIntermediateOutput(this.conf)) {
            Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateOutputCompressorClass(this.conf, DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
        } else {
            this.codec = null;
        }
        this.ouputFileManager = TezRuntimeUtils.instantiateTaskOutputManager(conf, outputContext);
        LOG.info((Object)("Created KVWriter -> compressionCodec: " + (this.codec == null ? "NoCompressionCodec" : this.codec.getClass().getName())));
        this.outputPath = this.ouputFileManager.getOutputFileForWrite();
        LOG.info((Object)("Writing data file: " + this.outputPath));
        this.writer = new IFile.Writer(conf, this.rfs, this.outputPath, this.keyClass, this.valClass, this.codec, null, this.outputBytesCounter);
    }

    public boolean close() throws IOException {
        this.closed = true;
        this.writer.close();
        long rawLen = this.writer.getRawLength();
        long compLen = this.writer.getCompressedLength();
        this.outputBytesCounterWithOverhead.increment(rawLen);
        this.outputMaterializedBytesCounter.increment(compLen);
        TezIndexRecord rec = new TezIndexRecord(0L, rawLen, compLen);
        TezSpillRecord sr = new TezSpillRecord(1);
        sr.putIndex(rec, 0);
        this.indexPath = this.ouputFileManager.getOutputIndexFileForWrite(24L);
        LOG.info((Object)("Writing index file: " + this.indexPath));
        sr.writeToFile(this.indexPath, this.conf);
        return this.numRecords > 0;
    }

    @Override
    public void write(Object key, Object value) throws IOException {
        this.writer.append(key, value);
        this.outputRecordsCounter.increment(1L);
        ++this.numRecords;
    }

    @Override
    public void write(Object key, Iterable<Object> values) throws IOException {
        this.writer.appendKeyValues(key, values.iterator());
        this.outputRecordsCounter.increment(1L);
        ++this.numRecords;
    }

    public long getRawLength() {
        Preconditions.checkState((boolean)this.closed, (Object)"Only available after the Writer has been closed");
        return this.writer.getRawLength();
    }

    public long getCompressedLength() {
        Preconditions.checkState((boolean)this.closed, (Object)"Only available after the Writer has been closed");
        return this.writer.getCompressedLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() throws IOException {
        Preconditions.checkState((boolean)this.closed, (Object)"Only available after the Writer has been closed");
        FSDataInputStream inStream = null;
        byte[] buf = null;
        try {
            inStream = this.rfs.open(this.outputPath);
            buf = new byte[(int)this.getCompressedLength()];
            IOUtils.readFully((InputStream)inStream, (byte[])buf, (int)0, (int)((int)this.getCompressedLength()));
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return buf;
    }
}

