/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.RawComparator;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;

public class OrderedGroupedMergedKVInput
extends MergedLogicalInput {
    private static final Log LOG = LogFactory.getLog(OrderedGroupedMergedKVInput.class);
    private final Set<Input> completedInputs = Collections.newSetFromMap(new IdentityHashMap());

    public OrderedGroupedMergedKVInput(MergedInputContext context, List<Input> inputs) {
        super(context, inputs);
    }

    public KeyValuesReader getReader() throws Exception {
        return new OrderedGroupedMergedKeyValuesReader(this.getInputs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstituentInputIsReady(Input input) {
        Set<Input> set = this.completedInputs;
        synchronized (set) {
            this.completedInputs.add(input);
            if (this.completedInputs.size() == this.getInputs().size()) {
                this.informInputReady();
            }
        }
    }

    private static class OrderedGroupedMergedKeyValuesReader
    extends KeyValuesReader {
        private final PriorityQueue<KeyValuesReader> pQueue;
        private final RawComparator keyComparator;
        private final List<KeyValuesReader> finishedReaders;
        private final ValuesIterable currentValues;
        private KeyValuesReader nextKVReader;
        private Object currentKey;

        public OrderedGroupedMergedKeyValuesReader(List<Input> inputs) throws Exception {
            this.keyComparator = ((OrderedGroupedKVInput)inputs.get(0)).getInputKeyComparator();
            this.pQueue = new PriorityQueue<KeyValuesReader>(inputs.size(), new KVReaderComparator(this.keyComparator));
            this.finishedReaders = new ArrayList<KeyValuesReader>(inputs.size());
            for (Input input : inputs) {
                KeyValuesReader reader = (KeyValuesReader)input.getReader();
                if (!reader.next()) continue;
                this.pQueue.add(reader);
            }
            this.currentValues = new ValuesIterable();
        }

        private void advanceAndAddToQueue(KeyValuesReader kvsReadr) throws IOException {
            if (kvsReadr.next()) {
                this.pQueue.add(kvsReadr);
            }
        }

        private void addToQueue(KeyValuesReader kvsReadr) throws IOException {
            if (kvsReadr != null) {
                this.pQueue.add(kvsReadr);
            }
        }

        @Override
        public boolean next() throws IOException {
            this.currentValues.discardCurrent();
            for (KeyValuesReader reader : this.finishedReaders) {
                this.advanceAndAddToQueue(reader);
            }
            this.finishedReaders.clear();
            this.nextKVReader = this.pQueue.poll();
            if (this.nextKVReader != null) {
                this.currentKey = this.nextKVReader.getCurrentKey();
                this.currentValues.moveToNext();
                return true;
            }
            return false;
        }

        @Override
        public Object getCurrentKey() throws IOException {
            return this.currentKey;
        }

        @Override
        public Iterable<Object> getCurrentValues() throws IOException {
            return this.currentValues;
        }

        private static class KVReaderComparator
        implements Comparator<KeyValuesReader> {
            private RawComparator keyComparator;

            public KVReaderComparator(RawComparator keyComparator) {
                this.keyComparator = keyComparator;
            }

            @Override
            public int compare(KeyValuesReader o1, KeyValuesReader o2) {
                try {
                    return this.keyComparator.compare(o1.getCurrentKey(), o2.getCurrentKey());
                }
                catch (IOException e) {
                    LOG.error((Object)"Caught exception while comparing keys in shuffle input", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        private class ValuesIterator
        implements Iterator<Object> {
            private Iterator<Object> currentValuesIter;

            private ValuesIterator() {
            }

            public void moveToNext() throws IOException {
                this.currentValuesIter = OrderedGroupedMergedKeyValuesReader.this.nextKVReader.getCurrentValues().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentValuesIter != null) {
                    if (this.currentValuesIter.hasNext()) {
                        return true;
                    }
                    OrderedGroupedMergedKeyValuesReader.this.finishedReaders.add(OrderedGroupedMergedKeyValuesReader.this.nextKVReader);
                    OrderedGroupedMergedKeyValuesReader.this.nextKVReader = (KeyValuesReader)((Object)OrderedGroupedMergedKeyValuesReader.this.pQueue.poll());
                    try {
                        if (OrderedGroupedMergedKeyValuesReader.this.nextKVReader != null && OrderedGroupedMergedKeyValuesReader.this.keyComparator.compare(OrderedGroupedMergedKeyValuesReader.this.currentKey, OrderedGroupedMergedKeyValuesReader.this.nextKVReader.getCurrentKey()) == 0) {
                            this.currentValuesIter = OrderedGroupedMergedKeyValuesReader.this.nextKVReader.getCurrentValues().iterator();
                            return true;
                        }
                        OrderedGroupedMergedKeyValuesReader.this.addToQueue(OrderedGroupedMergedKeyValuesReader.this.nextKVReader);
                        this.currentValuesIter = null;
                        return false;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return false;
            }

            public void discardCurrent() throws IOException {
                if (this.currentValuesIter != null) {
                    do {
                        OrderedGroupedMergedKeyValuesReader.this.finishedReaders.add(OrderedGroupedMergedKeyValuesReader.this.nextKVReader);
                        OrderedGroupedMergedKeyValuesReader.this.nextKVReader = (KeyValuesReader)((Object)OrderedGroupedMergedKeyValuesReader.this.pQueue.poll());
                    } while (OrderedGroupedMergedKeyValuesReader.this.nextKVReader != null && OrderedGroupedMergedKeyValuesReader.this.keyComparator.compare(OrderedGroupedMergedKeyValuesReader.this.currentKey, OrderedGroupedMergedKeyValuesReader.this.nextKVReader.getCurrentKey()) == 0);
                    OrderedGroupedMergedKeyValuesReader.this.addToQueue(OrderedGroupedMergedKeyValuesReader.this.nextKVReader);
                    this.currentValuesIter = null;
                }
            }

            @Override
            public Object next() {
                return this.currentValuesIter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private class ValuesIterable
        implements Iterable<Object> {
            private ValuesIterator iterator;

            private ValuesIterable() {
                this.iterator = new ValuesIterator();
            }

            @Override
            public Iterator<Object> iterator() {
                return this.iterator;
            }

            public void discardCurrent() throws IOException {
                this.iterator.discardCurrent();
            }

            public void moveToNext() throws IOException {
                this.iterator.moveToNext();
            }
        }
    }
}

