/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YARNMaster {
    public static String getMasterUserName(Configuration conf) {
        return conf.get("yarn.resourcemanager.principal");
    }

    public static InetSocketAddress getMasterAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static String getMasterPrincipal(Configuration conf) throws IOException {
        String masterHostname = YARNMaster.getMasterAddress(conf).getHostName();
        return SecurityUtil.getServerPrincipal((String)YARNMaster.getMasterUserName(conf), (String)masterHostname);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIALIZING,
        RUNNING;

    }
}

