/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.annotation.ConfigurationClass;
import org.apache.tez.common.annotation.ConfigurationProperty;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@ConfigurationClass(templateFileName="tez-runtime-default-template.xml")
public class TezRuntimeConfiguration {
    private static final String TEZ_RUNTIME_PREFIX = "tez.runtime.";
    private static final Set<String> tezRuntimeKeys = new HashSet<String>();
    private static Set<String> umnodifiableTezRuntimeKeySet;
    private static final Set<String> otherKeys;
    private static Set<String> unmodifiableOtherKeySet;
    private static Configuration defaultConf;
    private static final Map<String, String> tezRuntimeConfMap;
    private static final Map<String, String> otherConfMap;
    private static final List<String> allowedPrefixes;
    private static List<String> unmodifiableAllowedPrefixes;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_IFILE_READAHEAD = "tez.runtime.ifile.readahead";
    public static final boolean TEZ_RUNTIME_IFILE_READAHEAD_DEFAULT = true;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_IFILE_READAHEAD_BYTES = "tez.runtime.ifile.readahead.bytes";
    public static final int TEZ_RUNTIME_IFILE_READAHEAD_BYTES_DEFAULT = 0x400000;
    public static final int TEZ_RUNTIME_IFILE_BUFFER_SIZE_DEFAULT = -1;
    public static final String TEZ_RUNTIME_IO_FILE_BUFFER_SIZE = "io.file.buffer.size";
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_IO_SORT_FACTOR = "tez.runtime.io.sort.factor";
    public static final int TEZ_RUNTIME_IO_SORT_FACTOR_DEFAULT = 100;
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SORT_SPILL_PERCENT = "tez.runtime.sort.spill.percent";
    public static final float TEZ_RUNTIME_SORT_SPILL_PERCENT_DEFAULT = 0.8f;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_IO_SORT_MB = "tez.runtime.io.sort.mb";
    public static final int TEZ_RUNTIME_IO_SORT_MB_DEFAULT = 100;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_INDEX_CACHE_MEMORY_LIMIT_BYTES = "tez.runtime.index.cache.memory.limit.bytes";
    public static final int TEZ_RUNTIME_INDEX_CACHE_MEMORY_LIMIT_BYTES_DEFAULT = 0x100000;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_COMBINE_MIN_SPILLS = "tez.runtime.combine.min.spills";
    public static final int TEZ_RUNTIME_COMBINE_MIN_SPILLS_DEFAULT = 3;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_PIPELINED_SORTER_MIN_BLOCK_SIZE_IN_MB = "tez.runtime.pipelined.sorter.min-block.size.in.mb";
    public static final int TEZ_RUNTIME_PIPELINED_SORTER_MIN_BLOCK_SIZE_IN_MB_DEFAULT = 2000;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_PIPELINED_SORTER_LAZY_ALLOCATE_MEMORY = "tez.runtime.pipelined.sorter.lazy-allocate.memory";
    public static final boolean TEZ_RUNTIME_PIPELINED_SORTER_LAZY_ALLOCATE_MEMORY_DEFAULT = false;
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_SORTER_CLASS = "tez.runtime.sorter.class";
    public static final String TEZ_RUNTIME_SORTER_CLASS_DEFAULT;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_PIPELINED_SORTER_SORT_THREADS = "tez.runtime.pipelined.sorter.sort.threads";
    public static final int TEZ_RUNTIME_PIPELINED_SORTER_SORT_THREADS_DEFAULT = 2;
    @ConfigurationProperty(type="int")
    public static final String TEZ_RUNTIME_UNORDERED_PARTITIONED_KVWRITER_BUFFER_MERGE_PERCENT = "tez.runtime.unordered-partitioned-kvwriter.buffer-merge-percent";
    public static final int TEZ_RUNTIME_UNORDERED_PARTITIONED_KVWRITER_BUFFER_MERGE_PERCENT_DEFAULT = 0;
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_REPORT_PARTITION_STATS = "tez.runtime.report.partition.stats";
    public static final String TEZ_RUNTIME_REPORT_PARTITION_STATS_DEFAULT;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_UNORDERED_OUTPUT_BUFFER_SIZE_MB = "tez.runtime.unordered.output.buffer.size-mb";
    public static final int TEZ_RUNTIME_UNORDERED_OUTPUT_BUFFER_SIZE_MB_DEFAULT = 100;
    @InterfaceAudience.Private
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_UNORDERED_OUTPUT_MAX_PER_BUFFER_SIZE_BYTES = "tez.runtime.unordered.output.max-per-buffer.size-bytes";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_PARTITIONER_CLASS = "tez.runtime.partitioner.class";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_COMBINER_CLASS = "tez.runtime.combiner.class";
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_PARALLEL_COPIES = "tez.runtime.shuffle.parallel.copies";
    public static final int TEZ_RUNTIME_SHUFFLE_PARALLEL_COPIES_DEFAULT = 20;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_FETCH_FAILURES_LIMIT = "tez.runtime.shuffle.fetch.failures.limit";
    public static final int TEZ_RUNTIME_SHUFFLE_FETCH_FAILURES_LIMIT_DEFAULT = 5;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_HOST_PENALTY_TIME_LIMIT_MS = "tez.runtime.shuffle.host.penalty.time.limit";
    public static final int TEZ_RUNTIME_SHUFFLE_HOST_PENALTY_TIME_LIMIT_MS_DEFAULT = 600000;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_SOURCE_ATTEMPT_ABORT_LIMIT = "tez.runtime.shuffle.src-attempt.abort.limit";
    public static final int TEZ_RUNTIME_SHUFFLE_SOURCE_ATTEMPT_ABORT_LIMIT_DEFAULT = -1;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_ACCEPTABLE_HOST_FETCH_FAILURE_FRACTION = "tez.runtime.shuffle.acceptable.host-fetch.failure.fraction";
    public static final float TEZ_RUNTIME_SHUFFLE_ACCEPTABLE_HOST_FETCH_FAILURE_FRACTION_DEFAULT = 0.2f;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_MIN_FAILURES_PER_HOST = "tez.runtime.shuffle.min.failures.per.host";
    public static final int TEZ_RUNTIME_SHUFFLE_MIN_FAILURES_PER_HOST_DEFAULT = 4;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_MAX_STALL_TIME_FRACTION = "tez.runtime.shuffle.max.stall.time.fraction";
    public static final float TEZ_RUNTIME_SHUFFLE_MAX_STALL_TIME_FRACTION_DEFAULT = 0.5f;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_MIN_REQUIRED_PROGRESS_FRACTION = "tez.runtime.shuffle.min.required.progress.fraction";
    public static final float TEZ_RUNTIME_SHUFFLE_MIN_REQUIRED_PROGRESS_FRACTION_DEFAULT = 0.5f;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_MAX_ALLOWED_FAILED_FETCH_ATTEMPT_FRACTION = "tez.runtime.shuffle.max.allowed.failed.fetch.fraction";
    public static final float TEZ_RUNTIME_SHUFFLE_MAX_ALLOWED_FAILED_FETCH_ATTEMPT_FRACTION_DEFAULT = 0.5f;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_FAILED_CHECK_SINCE_LAST_COMPLETION = "tez.runtime.shuffle.failed.check.since-last.completion";
    public static final boolean TEZ_RUNTIME_SHUFFLE_FAILED_CHECK_SINCE_LAST_COMPLETION_DEFAULT = true;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_FETCH_MAX_TASK_OUTPUT_AT_ONCE = "tez.runtime.shuffle.fetch.max.task.output.at.once";
    public static final int TEZ_RUNTIME_SHUFFLE_FETCH_MAX_TASK_OUTPUT_AT_ONCE_DEFAULT = 20;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_NOTIFY_READERROR = "tez.runtime.shuffle.notify.readerror";
    public static final boolean TEZ_RUNTIME_SHUFFLE_NOTIFY_READERROR_DEFAULT = true;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_CONNECT_TIMEOUT = "tez.runtime.shuffle.connect.timeout";
    public static final int TEZ_RUNTIME_SHUFFLE_STALLED_COPY_TIMEOUT_DEFAULT = 180000;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_ENABLED = "tez.runtime.shuffle.keep-alive.enabled";
    public static final boolean TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_ENABLED_DEFAULT = false;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_MAX_CONNECTIONS = "tez.runtime.shuffle.keep-alive.max.connections";
    public static final int TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_MAX_CONNECTIONS_DEFAULT = 20;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_READ_TIMEOUT = "tez.runtime.shuffle.read.timeout";
    public static final int TEZ_RUNTIME_SHUFFLE_READ_TIMEOUT_DEFAULT = 180000;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_BUFFER_SIZE = "tez.runtime.shuffle.buffersize";
    public static final int TEZ_RUNTIME_SHUFFLE_BUFFER_SIZE_DEFAULT = 8192;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_USE_ASYNC_HTTP = "tez.runtime.shuffle.use.async.http";
    public static final boolean TEZ_RUNTIME_SHUFFLE_USE_ASYNC_HTTP_DEFAULT = false;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_ENABLE_SSL = "tez.runtime.shuffle.ssl.enable";
    public static final boolean TEZ_RUNTIME_SHUFFLE_ENABLE_SSL_DEFAULT = false;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_FETCH_VERIFY_DISK_CHECKSUM = "tez.runtime.shuffle.fetch.verify-disk-checksum";
    public static final boolean TEZ_RUNTIME_SHUFFLE_FETCH_VERIFY_DISK_CHECKSUM_DEFAULT = true;
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_FETCH_BUFFER_PERCENT = "tez.runtime.shuffle.fetch.buffer.percent";
    public static final float TEZ_RUNTIME_SHUFFLE_FETCH_BUFFER_PERCENT_DEFAULT = 0.9f;
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_MEMORY_LIMIT_PERCENT = "tez.runtime.shuffle.memory.limit.percent";
    public static final float TEZ_RUNTIME_SHUFFLE_MEMORY_LIMIT_PERCENT_DEFAULT = 0.25f;
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_SHUFFLE_MERGE_PERCENT = "tez.runtime.shuffle.merge.percent";
    public static final float TEZ_RUNTIME_SHUFFLE_MERGE_PERCENT_DEFAULT = 0.9f;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_MEMTOMEM_SEGMENTS = "tez.runtime.shuffle.memory-to-memory.segments";
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_ENABLE_MEMTOMEM = "tez.runtime.shuffle.memory-to-memory.enable";
    public static final boolean TEZ_RUNTIME_SHUFFLE_ENABLE_MEMTOMEM_DEFAULT = false;
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_SHUFFLE_FETCHER_USE_SHARED_POOL = "tez.runtime.shuffle.fetcher.use-shared-pool";
    public static final boolean TEZ_RUNTIME_SHUFFLE_FETCHER_USE_SHARED_POOL_DEFAULT = false;
    @ConfigurationProperty(type="float")
    public static final String TEZ_RUNTIME_INPUT_POST_MERGE_BUFFER_PERCENT = "tez.runtime.task.input.post-merge.buffer.percent";
    public static final float TEZ_RUNTIME_INPUT_BUFFER_PERCENT_DEFAULT = 0.0f;
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_GROUP_COMPARATOR_CLASS = "tez.runtime.group.comparator.class";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_INTERNAL_SORTER_CLASS = "tez.runtime.internal.sorter.class";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_KEY_COMPARATOR_CLASS = "tez.runtime.key.comparator.class";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_KEY_CLASS = "tez.runtime.key.class";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_VALUE_CLASS = "tez.runtime.value.class";
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_COMPRESS = "tez.runtime.compress";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_COMPRESS_CODEC = "tez.runtime.compress.codec";
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_KEY_SECONDARY_COMPARATOR_CLASS = "tez.runtime.key.secondary.comparator.class";
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_EMPTY_PARTITION_INFO_VIA_EVENTS_ENABLED = "tez.runtime.empty.partitions.info-via-events.enabled";
    public static final boolean TEZ_RUNTIME_EMPTY_PARTITION_INFO_VIA_EVENTS_ENABLED_DEFAULT = true;
    @InterfaceAudience.Private
    public static final String TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_ENABLED = "tez.runtime.transfer.data-via-events.enabled";
    @InterfaceAudience.Private
    public static final boolean TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_ENABLED_DEFAULT = true;
    @InterfaceAudience.Private
    public static final String TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_MAX_SIZE = "tez.runtime.transfer.data-via-events.max-size";
    @InterfaceAudience.Private
    public static final int TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_MAX_SIZE_DEFAULT = 512;
    @InterfaceAudience.Private
    public static final String TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_SUPPORT_IN_MEM_FILE = "tez.runtime.transfer.data-via-events.support.in-mem.file";
    @InterfaceAudience.Private
    public static final boolean TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_SUPPORT_IN_MEM_FILE_DEFAULT = true;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_OPTIMIZE_LOCAL_FETCH = "tez.runtime.optimize.local.fetch";
    public static final boolean TEZ_RUNTIME_OPTIMIZE_LOCAL_FETCH_DEFAULT = true;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_PIPELINED_SHUFFLE_ENABLED = "tez.runtime.pipelined-shuffle.enabled";
    public static final boolean TEZ_RUNTIME_PIPELINED_SHUFFLE_ENABLED_DEFAULT = false;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_ENABLE_FINAL_MERGE_IN_OUTPUT = "tez.runtime.enable.final-merge.in.output";
    public static final boolean TEZ_RUNTIME_ENABLE_FINAL_MERGE_IN_OUTPUT_DEFAULT = true;
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_SHUFFLE_BATCH_WAIT = "tez.runtime.shuffle.batch.wait";
    public static final int TEZ_RUNTIME_SHUFFLE_BATCH_WAIT_DEFAULT = -1;
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_OPTIMIZE_SHARED_FETCH = "tez.runtime.optimize.shared.fetch";
    public static final boolean TEZ_RUNTIME_OPTIMIZE_SHARED_FETCH_DEFAULT = false;
    @InterfaceStability.Unstable
    @InterfaceAudience.Private
    @ConfigurationProperty(type="boolean")
    public static final String TEZ_RUNTIME_CLEANUP_FILES_ON_INTERRUPT = "tez.runtime.cleanup.files.on.interrupt";
    public static final boolean TEZ_RUNTIME_CLEANUP_FILES_ON_INTERRUPT_DEFAULT = false;
    @ConfigurationProperty
    public static final String TEZ_RUNTIME_CONVERT_USER_PAYLOAD_TO_HISTORY_TEXT = "tez.runtime.convert.user-payload.to.history-text";
    public static final boolean TEZ_RUNTIME_CONVERT_USER_PAYLOAD_TO_HISTORY_TEXT_DEFAULT = false;
    @InterfaceStability.Unstable
    @InterfaceAudience.Private
    @ConfigurationProperty(type="integer")
    public static final String TEZ_RUNTIME_RECORDS_BEFORE_PROGRESS = "tez.runtime.merge.progress.records";
    public static final long TEZ_RUNTIME_RECORDS_BEFORE_PROGRESS_DEFAULT = 10000L;

    @InterfaceAudience.Private
    public static Set<String> getRuntimeConfigKeySet() {
        return umnodifiableTezRuntimeKeySet;
    }

    @InterfaceAudience.Private
    public static Set<String> getRuntimeAdditionalConfigKeySet() {
        return unmodifiableOtherKeySet;
    }

    @InterfaceAudience.Private
    public static List<String> getAllowedPrefixes() {
        return allowedPrefixes;
    }

    @InterfaceAudience.Private
    public static Map<String, String> getTezRuntimeConfigDefaults() {
        return Collections.unmodifiableMap(tezRuntimeConfMap);
    }

    @InterfaceAudience.Private
    public static Map<String, String> getOtherConfigDefaults() {
        return Collections.unmodifiableMap(otherConfMap);
    }

    static {
        otherKeys = new HashSet<String>();
        defaultConf = new Configuration(false);
        tezRuntimeConfMap = new HashMap<String, String>();
        otherConfMap = new HashMap<String, String>();
        allowedPrefixes = new ArrayList<String>();
        Configuration.addDeprecation((String)"tez.runtime.sort.threads", (String)TEZ_RUNTIME_PIPELINED_SORTER_SORT_THREADS);
        TEZ_RUNTIME_SORTER_CLASS_DEFAULT = OrderedPartitionedKVOutputConfig.SorterImpl.PIPELINED.name();
        TEZ_RUNTIME_REPORT_PARTITION_STATS_DEFAULT = ReportPartitionStats.MEMORY_OPTIMIZED.getType();
        tezRuntimeKeys.add(TEZ_RUNTIME_IFILE_READAHEAD);
        tezRuntimeKeys.add(TEZ_RUNTIME_IFILE_READAHEAD_BYTES);
        tezRuntimeKeys.add(TEZ_RUNTIME_IO_FILE_BUFFER_SIZE);
        tezRuntimeKeys.add(TEZ_RUNTIME_IO_SORT_FACTOR);
        tezRuntimeKeys.add(TEZ_RUNTIME_SORT_SPILL_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_IO_SORT_MB);
        tezRuntimeKeys.add(TEZ_RUNTIME_INDEX_CACHE_MEMORY_LIMIT_BYTES);
        tezRuntimeKeys.add(TEZ_RUNTIME_COMBINE_MIN_SPILLS);
        tezRuntimeKeys.add(TEZ_RUNTIME_PIPELINED_SORTER_SORT_THREADS);
        tezRuntimeKeys.add(TEZ_RUNTIME_PIPELINED_SORTER_MIN_BLOCK_SIZE_IN_MB);
        tezRuntimeKeys.add(TEZ_RUNTIME_PIPELINED_SORTER_LAZY_ALLOCATE_MEMORY);
        tezRuntimeKeys.add(TEZ_RUNTIME_UNORDERED_OUTPUT_BUFFER_SIZE_MB);
        tezRuntimeKeys.add(TEZ_RUNTIME_UNORDERED_OUTPUT_MAX_PER_BUFFER_SIZE_BYTES);
        tezRuntimeKeys.add(TEZ_RUNTIME_PARTITIONER_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_COMBINER_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_USE_ASYNC_HTTP);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_PARALLEL_COPIES);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FETCH_FAILURES_LIMIT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FETCH_MAX_TASK_OUTPUT_AT_ONCE);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_NOTIFY_READERROR);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_CONNECT_TIMEOUT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_ENABLED);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_KEEP_ALIVE_MAX_CONNECTIONS);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_READ_TIMEOUT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_BUFFER_SIZE);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_ENABLE_SSL);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FETCH_VERIFY_DISK_CHECKSUM);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FETCH_BUFFER_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MEMORY_LIMIT_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MERGE_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MEMTOMEM_SEGMENTS);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_ENABLE_MEMTOMEM);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_ACCEPTABLE_HOST_FETCH_FAILURE_FRACTION);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MIN_FAILURES_PER_HOST);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MAX_STALL_TIME_FRACTION);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_SOURCE_ATTEMPT_ABORT_LIMIT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MAX_ALLOWED_FAILED_FETCH_ATTEMPT_FRACTION);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_MIN_REQUIRED_PROGRESS_FRACTION);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FAILED_CHECK_SINCE_LAST_COMPLETION);
        tezRuntimeKeys.add(TEZ_RUNTIME_REPORT_PARTITION_STATS);
        tezRuntimeKeys.add(TEZ_RUNTIME_INPUT_POST_MERGE_BUFFER_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_GROUP_COMPARATOR_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_INTERNAL_SORTER_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_KEY_COMPARATOR_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_KEY_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_VALUE_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_COMPRESS);
        tezRuntimeKeys.add(TEZ_RUNTIME_COMPRESS_CODEC);
        tezRuntimeKeys.add(TEZ_RUNTIME_KEY_SECONDARY_COMPARATOR_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_EMPTY_PARTITION_INFO_VIA_EVENTS_ENABLED);
        tezRuntimeKeys.add(TEZ_RUNTIME_PIPELINED_SHUFFLE_ENABLED);
        tezRuntimeKeys.add(TEZ_RUNTIME_ENABLE_FINAL_MERGE_IN_OUTPUT);
        tezRuntimeKeys.add(TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_ENABLED);
        tezRuntimeKeys.add(TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_MAX_SIZE);
        tezRuntimeKeys.add(TEZ_RUNTIME_TRANSFER_DATA_VIA_EVENTS_SUPPORT_IN_MEM_FILE);
        tezRuntimeKeys.add(TEZ_RUNTIME_RECORDS_BEFORE_PROGRESS);
        tezRuntimeKeys.add(TEZ_RUNTIME_OPTIMIZE_LOCAL_FETCH);
        tezRuntimeKeys.add(TEZ_RUNTIME_OPTIMIZE_SHARED_FETCH);
        tezRuntimeKeys.add(TEZ_RUNTIME_CONVERT_USER_PAYLOAD_TO_HISTORY_TEXT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SORTER_CLASS);
        tezRuntimeKeys.add(TEZ_RUNTIME_CLEANUP_FILES_ON_INTERRUPT);
        tezRuntimeKeys.add(TEZ_RUNTIME_UNORDERED_PARTITIONED_KVWRITER_BUFFER_MERGE_PERCENT);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_FETCHER_USE_SHARED_POOL);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_HOST_PENALTY_TIME_LIMIT_MS);
        tezRuntimeKeys.add(TEZ_RUNTIME_SHUFFLE_BATCH_WAIT);
        defaultConf.addResource("core-default.xml");
        defaultConf.addResource("core-site.xml");
        defaultConf.addResource("tez-site.xml");
        for (Map.Entry confEntry : defaultConf) {
            if (tezRuntimeKeys.contains(confEntry.getKey())) {
                tezRuntimeConfMap.put((String)confEntry.getKey(), (String)confEntry.getValue());
                continue;
            }
            otherConfMap.put((String)confEntry.getKey(), (String)confEntry.getValue());
            otherKeys.add((String)confEntry.getKey());
        }
        allowedPrefixes.add("io.");
        allowedPrefixes.add("file.");
        allowedPrefixes.add("fs.");
        allowedPrefixes.add("ssl.");
        umnodifiableTezRuntimeKeySet = Collections.unmodifiableSet(tezRuntimeKeys);
        unmodifiableOtherKeySet = Collections.unmodifiableSet(otherKeys);
        unmodifiableAllowedPrefixes = Collections.unmodifiableList(allowedPrefixes);
    }

    public static enum ReportPartitionStats {
        DISABLED("false"),
        ENABLED("true"),
        NONE("none"),
        MEMORY_OPTIMIZED("memory_optimized"),
        PRECISE("precise");

        private final String type;

        private ReportPartitionStats(String type) {
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }

        public boolean isEnabled() {
            return !this.equals((Object)DISABLED) && !this.equals((Object)NONE);
        }

        public boolean isPrecise() {
            return this.equals((Object)PRECISE);
        }

        public static ReportPartitionStats fromString(String type) {
            if (type != null) {
                for (ReportPartitionStats b : ReportPartitionStats.values()) {
                    if (!type.equalsIgnoreCase(b.type)) continue;
                    return b;
                }
            }
            throw new IllegalArgumentException("Invalid type " + type);
        }
    }
}

