/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.tez.common.ProtoConverters;
import org.apache.tez.common.TezConverterUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.CompositeRoutedDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptKilledEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.internals.api.events.SystemEventProtos;

public class TezEvent
implements Writable {
    private EventType eventType;
    private Event event;
    private EventMetaData sourceInfo;
    private EventMetaData destinationInfo;
    private long eventReceivedTime;

    public TezEvent() {
    }

    public TezEvent(Event event, EventMetaData sourceInfo) {
        this(event, sourceInfo, System.currentTimeMillis());
    }

    public TezEvent(Event event, EventMetaData sourceInfo, long time) {
        this.event = event;
        this.eventReceivedTime = time;
        this.setSourceInfo(sourceInfo);
        if (event instanceof DataMovementEvent) {
            this.eventType = EventType.DATA_MOVEMENT_EVENT;
        } else if (event instanceof CompositeDataMovementEvent) {
            this.eventType = EventType.COMPOSITE_DATA_MOVEMENT_EVENT;
        } else if (event instanceof CompositeRoutedDataMovementEvent) {
            this.eventType = EventType.COMPOSITE_ROUTED_DATA_MOVEMENT_EVENT;
        } else if (event instanceof VertexManagerEvent) {
            this.eventType = EventType.VERTEX_MANAGER_EVENT;
        } else if (event instanceof InputReadErrorEvent) {
            this.eventType = EventType.INPUT_READ_ERROR_EVENT;
        } else if (event instanceof TaskAttemptFailedEvent) {
            this.eventType = EventType.TASK_ATTEMPT_FAILED_EVENT;
        } else if (event instanceof TaskAttemptKilledEvent) {
            this.eventType = EventType.TASK_ATTEMPT_KILLED_EVENT;
        } else if (event instanceof TaskAttemptCompletedEvent) {
            this.eventType = EventType.TASK_ATTEMPT_COMPLETED_EVENT;
        } else if (event instanceof InputFailedEvent) {
            this.eventType = EventType.INPUT_FAILED_EVENT;
        } else if (event instanceof TaskStatusUpdateEvent) {
            this.eventType = EventType.TASK_STATUS_UPDATE_EVENT;
        } else if (event instanceof InputDataInformationEvent) {
            this.eventType = EventType.ROOT_INPUT_DATA_INFORMATION_EVENT;
        } else if (event instanceof InputInitializerEvent) {
            this.eventType = EventType.ROOT_INPUT_INITIALIZER_EVENT;
        } else {
            throw new TezUncheckedException("Unknown event, event=" + event.getClass().getName());
        }
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEventReceivedTime(long eventReceivedTime) {
        this.eventReceivedTime = eventReceivedTime;
    }

    public long getEventReceivedTime() {
        return this.eventReceivedTime;
    }

    public EventMetaData getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(EventMetaData sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public EventMetaData getDestinationInfo() {
        return this.destinationInfo;
    }

    public void setDestinationInfo(EventMetaData destinationInfo) {
        this.destinationInfo = destinationInfo;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    private void serializeEvent(DataOutput out) throws IOException {
        if (this.event == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.eventType.ordinal());
        out.writeLong(this.eventReceivedTime);
        if (this.eventType.equals((Object)EventType.TASK_STATUS_UPDATE_EVENT)) {
            TaskStatusUpdateEvent sEvt = (TaskStatusUpdateEvent)this.event;
            sEvt.write(out);
        } else {
            GeneratedMessage message;
            switch (this.eventType) {
                case DATA_MOVEMENT_EVENT: {
                    message = ProtoConverters.convertDataMovementEventToProto((DataMovementEvent)this.event);
                    break;
                }
                case COMPOSITE_ROUTED_DATA_MOVEMENT_EVENT: {
                    message = ProtoConverters.convertCompositeRoutedDataMovementEventToProto((CompositeRoutedDataMovementEvent)this.event);
                    break;
                }
                case COMPOSITE_DATA_MOVEMENT_EVENT: {
                    message = ProtoConverters.convertCompositeDataMovementEventToProto((CompositeDataMovementEvent)this.event);
                    break;
                }
                case VERTEX_MANAGER_EVENT: {
                    message = ProtoConverters.convertVertexManagerEventToProto((VertexManagerEvent)this.event);
                    break;
                }
                case INPUT_READ_ERROR_EVENT: {
                    InputReadErrorEvent ideEvt = (InputReadErrorEvent)this.event;
                    message = EventProtos.InputReadErrorEventProto.newBuilder().setIndex(ideEvt.getIndex()).setDiagnostics(ideEvt.getDiagnostics()).setVersion(ideEvt.getVersion()).build();
                    break;
                }
                case TASK_ATTEMPT_FAILED_EVENT: {
                    TaskAttemptFailedEvent tfEvt = (TaskAttemptFailedEvent)this.event;
                    message = SystemEventProtos.TaskAttemptFailedEventProto.newBuilder().setDiagnostics(tfEvt.getDiagnostics()).setTaskFailureType(TezConverterUtils.failureTypeToProto(tfEvt.getTaskFailureType())).build();
                    break;
                }
                case TASK_ATTEMPT_KILLED_EVENT: {
                    TaskAttemptKilledEvent tkEvent = (TaskAttemptKilledEvent)this.event;
                    message = SystemEventProtos.TaskAttemptKilledEventProto.newBuilder().setDiagnostics(tkEvent.getDiagnostics()).build();
                    break;
                }
                case TASK_ATTEMPT_COMPLETED_EVENT: {
                    message = SystemEventProtos.TaskAttemptCompletedEventProto.newBuilder().build();
                    break;
                }
                case INPUT_FAILED_EVENT: {
                    InputFailedEvent ifEvt = (InputFailedEvent)this.event;
                    message = EventProtos.InputFailedEventProto.newBuilder().setTargetIndex(ifEvt.getTargetIndex()).setVersion(ifEvt.getVersion()).build();
                    break;
                }
                case ROOT_INPUT_DATA_INFORMATION_EVENT: {
                    message = ProtoConverters.convertRootInputDataInformationEventToProto((InputDataInformationEvent)this.event);
                    break;
                }
                case ROOT_INPUT_INITIALIZER_EVENT: {
                    message = ProtoConverters.convertRootInputInitializerEventToProto((InputInitializerEvent)this.event);
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unknown TezEvent, type=" + (Object)((Object)this.eventType));
                }
            }
            if (out instanceof OutputStream) {
                int serializedSize = message.getSerializedSize();
                out.writeInt(serializedSize);
                int buffersize = serializedSize < 4096 ? serializedSize : 4096;
                CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)((OutputStream)((Object)out)), (int)buffersize);
                message.writeTo(codedOut);
                codedOut.flush();
            } else {
                byte[] eventBytes = message.toByteArray();
                out.writeInt(eventBytes.length);
                out.write(eventBytes);
            }
        }
    }

    private void deserializeEvent(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            this.event = null;
            return;
        }
        this.eventType = EventType.values()[in.readInt()];
        this.eventReceivedTime = in.readLong();
        if (this.eventType.equals((Object)EventType.TASK_STATUS_UPDATE_EVENT)) {
            this.event = new TaskStatusUpdateEvent();
            ((TaskStatusUpdateEvent)this.event).readFields(in);
        } else {
            int skipped;
            byte[] eventBytes;
            int eventBytesLen = in.readInt();
            int startOffset = 0;
            if (in instanceof DataInputBuffer) {
                eventBytes = ((DataInputBuffer)in).getData();
                startOffset = ((DataInputBuffer)in).getPosition();
            } else {
                eventBytes = new byte[eventBytesLen];
                in.readFully(eventBytes);
            }
            CodedInputStream input = CodedInputStream.newInstance((byte[])eventBytes, (int)startOffset, (int)eventBytesLen);
            switch (this.eventType) {
                case DATA_MOVEMENT_EVENT: {
                    EventProtos.DataMovementEventProto dmProto = EventProtos.DataMovementEventProto.parseFrom((CodedInputStream)input);
                    this.event = ProtoConverters.convertDataMovementEventFromProto(dmProto);
                    break;
                }
                case COMPOSITE_ROUTED_DATA_MOVEMENT_EVENT: {
                    EventProtos.CompositeRoutedDataMovementEventProto edmProto = EventProtos.CompositeRoutedDataMovementEventProto.parseFrom((byte[])eventBytes);
                    this.event = ProtoConverters.convertCompositeRoutedDataMovementEventFromProto(edmProto);
                    break;
                }
                case COMPOSITE_DATA_MOVEMENT_EVENT: {
                    EventProtos.CompositeEventProto cProto = EventProtos.CompositeEventProto.parseFrom((CodedInputStream)input);
                    this.event = ProtoConverters.convertCompositeDataMovementEventFromProto(cProto);
                    break;
                }
                case VERTEX_MANAGER_EVENT: {
                    EventProtos.VertexManagerEventProto vmProto = EventProtos.VertexManagerEventProto.parseFrom((CodedInputStream)input);
                    this.event = ProtoConverters.convertVertexManagerEventFromProto(vmProto);
                    break;
                }
                case INPUT_READ_ERROR_EVENT: {
                    EventProtos.InputReadErrorEventProto ideProto = EventProtos.InputReadErrorEventProto.parseFrom((CodedInputStream)input);
                    this.event = InputReadErrorEvent.create((String)ideProto.getDiagnostics(), (int)ideProto.getIndex(), (int)ideProto.getVersion());
                    break;
                }
                case TASK_ATTEMPT_FAILED_EVENT: {
                    SystemEventProtos.TaskAttemptFailedEventProto tfProto = SystemEventProtos.TaskAttemptFailedEventProto.parseFrom(input);
                    this.event = new TaskAttemptFailedEvent(tfProto.getDiagnostics(), TezConverterUtils.failureTypeFromProto(tfProto.getTaskFailureType()));
                    break;
                }
                case TASK_ATTEMPT_KILLED_EVENT: {
                    SystemEventProtos.TaskAttemptKilledEventProto tkProto = SystemEventProtos.TaskAttemptKilledEventProto.parseFrom(input);
                    this.event = new TaskAttemptKilledEvent(tkProto.getDiagnostics());
                    break;
                }
                case TASK_ATTEMPT_COMPLETED_EVENT: {
                    this.event = new TaskAttemptCompletedEvent();
                    break;
                }
                case INPUT_FAILED_EVENT: {
                    EventProtos.InputFailedEventProto ifProto = EventProtos.InputFailedEventProto.parseFrom((CodedInputStream)input);
                    this.event = InputFailedEvent.create((int)ifProto.getTargetIndex(), (int)ifProto.getVersion());
                    break;
                }
                case ROOT_INPUT_DATA_INFORMATION_EVENT: {
                    EventProtos.RootInputDataInformationEventProto difProto = EventProtos.RootInputDataInformationEventProto.parseFrom((CodedInputStream)input);
                    this.event = ProtoConverters.convertRootInputDataInformationEventFromProto(difProto);
                    break;
                }
                case ROOT_INPUT_INITIALIZER_EVENT: {
                    EventProtos.RootInputInitializerEventProto riiProto = EventProtos.RootInputInitializerEventProto.parseFrom((CodedInputStream)input);
                    this.event = ProtoConverters.convertRootInputInitializerEventFromProto(riiProto);
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unexpected TezEvent, type=" + (Object)((Object)this.eventType));
                }
            }
            if (in instanceof DataInputBuffer && (skipped = in.skipBytes(eventBytesLen)) != eventBytesLen) {
                throw new TezUncheckedException("Expected to skip " + eventBytesLen + " bytes. Actually skipped = " + skipped);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        this.serializeEvent(out);
        if (this.sourceInfo != null) {
            out.writeBoolean(true);
            this.sourceInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.destinationInfo != null) {
            out.writeBoolean(true);
            this.destinationInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.deserializeEvent(in);
        if (in.readBoolean()) {
            this.sourceInfo = new EventMetaData();
            this.sourceInfo.readFields(in);
        }
        if (in.readBoolean()) {
            this.destinationInfo = new EventMetaData();
            this.destinationInfo.readFields(in);
        }
    }

    public String toString() {
        return "TezEvent{eventType=" + (Object)((Object)this.eventType) + ", sourceInfo=" + this.sourceInfo + ", destinationInfo=" + this.destinationInfo + '}';
    }
}

