/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.dag.api.OutputDescriptor;

public class OutputSpec
implements Writable {
    private String destinationVertexName;
    private OutputDescriptor outputDescriptor;
    private int physicalEdgeCount;

    public OutputSpec() {
    }

    public OutputSpec(String destinationVertexName, OutputDescriptor outputDescriptor, int physicalEdgeCount) {
        this.destinationVertexName = StringInterner.weakIntern((String)destinationVertexName);
        this.outputDescriptor = outputDescriptor;
        this.physicalEdgeCount = physicalEdgeCount;
    }

    public String getDestinationVertexName() {
        return this.destinationVertexName;
    }

    public OutputDescriptor getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public int getPhysicalEdgeCount() {
        return this.physicalEdgeCount;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.destinationVertexName);
        out.writeInt(this.physicalEdgeCount);
        this.outputDescriptor.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.destinationVertexName = StringInterner.weakIntern((String)in.readUTF());
        this.physicalEdgeCount = in.readInt();
        this.outputDescriptor = new OutputDescriptor();
        this.outputDescriptor.readFields(in);
    }

    public String toString() {
        return "{ destinationVertexName=" + this.destinationVertexName + ", physicalEdgeCount=" + this.physicalEdgeCount + ", outputClassName=" + this.outputDescriptor.getClassName() + " }";
    }
}

