/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

public class TezProcessorContextImpl
extends TezTaskContextImpl
implements ProcessorContext {
    private final UserPayload userPayload;
    private final EventMetaData sourceInfo;
    private final InputReadyTracker inputReadyTracker;

    public TezProcessorContextImpl(Configuration conf, String[] workDirs, int appAttemptNumber, TezUmbilical tezUmbilical, String dagName, String vertexName, int vertexParallelism, TezTaskAttemptID taskAttemptID, TezCounters counters, @Nullable UserPayload userPayload, RuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, ProcessorDescriptor processorDescriptor, InputReadyTracker inputReadyTracker, ObjectRegistry objectRegistry) {
        super(conf, workDirs, appAttemptNumber, dagName, vertexName, vertexParallelism, taskAttemptID, counters, runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (EntityDescriptor<?>)processorDescriptor, objectRegistry);
        Preconditions.checkNotNull((Object)inputReadyTracker, (Object)"inputReadyTracker is null");
        this.userPayload = userPayload == null ? UserPayload.create(null) : userPayload;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, this.taskVertexName, "", taskAttemptID);
        this.inputReadyTracker = inputReadyTracker;
    }

    public void sendEvents(List<Event> events) {
        Preconditions.checkNotNull(events, (Object)"events are null");
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public void setProgress(float progress) {
        this.runtimeTask.setProgress(progress);
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public boolean canCommit() throws IOException {
        return this.tezUmbilical.canCommit(this.taskAttemptID);
    }

    public Input waitForAnyInputReady(Collection<Input> inputs) throws InterruptedException {
        return this.inputReadyTracker.waitForAnyInputReady(inputs);
    }

    public void waitForAllInputsReady(Collection<Input> inputs) throws InterruptedException {
        this.inputReadyTracker.waitForAllInputsReady(inputs);
    }
}

