/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSpec
implements Writable {
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private String user;
    private ProcessorDescriptor processorDescriptor;
    private List<InputSpec> inputSpecList;
    private List<OutputSpec> outputSpecList;

    public TaskSpec() {
    }

    public TaskSpec(TezTaskAttemptID taskAttemptID, String user, String vertexName, ProcessorDescriptor processorDescriptor, List<InputSpec> inputSpecList, List<OutputSpec> outputSpecList) {
        this.taskAttemptId = taskAttemptID;
        this.vertexName = vertexName;
        this.user = user;
        this.processorDescriptor = processorDescriptor;
        this.inputSpecList = inputSpecList;
        this.outputSpecList = outputSpecList;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public String getUser() {
        return this.user;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public List<InputSpec> getInputs() {
        return this.inputSpecList;
    }

    public List<OutputSpec> getOutputs() {
        return this.outputSpecList;
    }

    public void write(DataOutput out) throws IOException {
        this.taskAttemptId.write(out);
        out.writeUTF(this.vertexName);
        this.processorDescriptor.write(out);
        out.writeInt(this.inputSpecList.size());
        for (InputSpec inputSpec : this.inputSpecList) {
            inputSpec.write(out);
        }
        out.writeInt(this.outputSpecList.size());
        for (OutputSpec outputSpec : this.outputSpecList) {
            outputSpec.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.taskAttemptId = new TezTaskAttemptID();
        this.taskAttemptId.readFields(in);
        this.vertexName = in.readUTF();
        this.processorDescriptor = new ProcessorDescriptor();
        this.processorDescriptor.readFields(in);
        int numInputSpecs = in.readInt();
        this.inputSpecList = new ArrayList<InputSpec>(numInputSpecs);
        for (int i = 0; i < numInputSpecs; ++i) {
            InputSpec inputSpec = new InputSpec();
            inputSpec.readFields(in);
            this.inputSpecList.add(inputSpec);
        }
        int numOutputSpecs = in.readInt();
        this.outputSpecList = new ArrayList<OutputSpec>(numOutputSpecs);
        for (int i = 0; i < numOutputSpecs; ++i) {
            OutputSpec outputSpec = new OutputSpec();
            outputSpec.readFields(in);
            this.outputSpecList.add(outputSpec);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TaskAttemptID:" + this.taskAttemptId);
        sb.append(", processorName=" + this.processorDescriptor.getClassName() + ", inputSpecListSize=" + this.inputSpecList.size() + ", outputSpecListSize=" + this.outputSpecList.size());
        sb.append(", inputSpecList=[");
        for (InputSpec inputSpec : this.inputSpecList) {
            sb.append("{" + inputSpec.toString() + "}, ");
        }
        sb.append("], outputSpecList=[");
        for (OutputSpec outputSpec : this.outputSpecList) {
            sb.append("{" + outputSpec.toString() + "}, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

